/**
 * Project Name:qiho-center-biz File Name:RefundResult.java Package Name:com.qiho.center.biz.model
 * Date:2017年7月19日下午4:27:01 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.model;

/**
 * ClassName:RefundResult <br/>
 * 退款结果. <br/>
 * Date: 2017年7月19日 下午4:27:01 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class RefundResult {

    /** 退款对应的订单ID */
    private String  orderId;

    /** 退款请求号，一个订单多次部分退款的时候必填 */
    private String  fundId;

    /** 退款原因 */
    private String  refundReason;

    /** 退款金额，单位：分 */
    private Integer refundAmt;

    /** 是否请求成功 */
    private Boolean isSuccess;
    /**
     * 外部流水号
     */
    private String  outTradeNo;
	/**
     * 成功:SUCCESS 失败: FAIL 退款中:PROCESSING
     */
    private String  refundStatus;

    public static final String  REFUND_STATUS_SUCCESS = "success";
    public static final String  REFUND_STATUS_FAIL = "fail";
    public static final String  REFUND_STATUS_PROCESSING = "processing";

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * fundId.
     *
     * @return the fundId
     */
    public String getFundId() {
        return fundId;
    }

    /**
     * fundId.
     *
     * @param fundId the fundId to set
     */
    public void setFundId(String fundId) {
        this.fundId = fundId;
    }

    /**
     * refundReason.
     *
     * @return the refundReason
     */
    public String getRefundReason() {
        return refundReason;
    }

    /**
     * refundReason.
     *
     * @param refundReason the refundReason to set
     */
    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    /**
     * refundAmt.
     *
     * @return the refundAmt
     */
    public Integer getRefundAmt() {
        return refundAmt;
    }

    /**
     * refundAmt.
     *
     * @param refundAmt the refundAmt to set
     */
    public void setRefundAmt(Integer refundAmt) {
        this.refundAmt = refundAmt;
    }

    /**
     * isSuccess.
     *
     * @return the isSuccess
     */
    public Boolean getIsSuccess() {
        return isSuccess;
    }

    /**
     * isSuccess.
     *
     * @param isSuccess the isSuccess to set
     */
    public void setIsSuccess(Boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    /**
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "RefundResult [orderId=" + orderId + ", fundId=" + fundId + ", refundReason=" + refundReason
               + ", refundAmt=" + refundAmt + ", isSuccess=" + isSuccess + "]";
    }

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

    public String getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }
}
