package com.qiho.center.biz.paychannel.pay;

import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;

import org.springframework.stereotype.Component;

import java.util.EnumMap;

/**
 * ClassName:PayChannelDecider <br/>
 * 支付渠道决策. <br/>
 * Date: 2017年7月17日 下午8:34:45 <br/>
 *
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component("payChannelDecider")
public class PayChannelDecider {

    /** 支付渠道MAP */
    private static EnumMap<PayTypeEnum, PayChannelProcessor> payChannelMap = new EnumMap<>(PayTypeEnum.class);

    /**
     *
     * @author zhanglihui
     * @param payType
     * @return 具体的支付渠道处理器
     */
    public PayChannelProcessor decidePayChannel(PayTypeEnum payType) {
        return payChannelMap.get(payType);
    }

    /**
     * 用于注入支付渠道处理器，在spring初始化时被注入
     *
     * @param payType
     * @param payChannelProcessor
     */
    public static void registPaychannel(PayTypeEnum payType, PayChannelProcessor payChannelProcessor) {
        if (payType == null || payChannelProcessor == null) {
            throw new QihoException("registPaychannel 时参数出现null");
        }
        payChannelMap.put(payType, payChannelProcessor);
    }
}
