package com.qiho.center.biz.remoteservice.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.center.biz.bo.BlackListBo;
import com.qiho.center.biz.service.BlackListService;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2017/5/22.
 */
@Service
public class RemoteExpressBlackListServiceImpl implements RemoteExpressBlackListService {

    @Autowired
    private BlackListService blackListService;

    @Autowired
    private BlackListBo blackListBo;

    @Override
    public DubboResult<PagenationDto<ExpressBlackListDto>> findExpressBlackPage(ExpressBlackListPageParams params) {
        return DubboResult.successResult(blackListService.findExpressBlackPage(params));
    }

    @Override
    public DubboResult<Long> findOneBlack(ExpressCompanyEnum expressCompany, String addressCode) {
        return DubboResult.successResult(blackListService.findOneBlack(expressCompany,addressCode));
    }

    @Override
    public DubboResult<Boolean> deleteBlackList(Long id) {
        return DubboResult.successResult(blackListService.deleteById(id,QueryBlackListTypeEnum.EXPRESS_COMPANY));
    }

    @Override
    public DubboResult<Integer> batchAddExpressBlackList(String cacheKey, List<ExpressBlackListOperationParams> list){
        return DubboResult.successResult(blackListBo.batchExpressBlackList(cacheKey,list));
    }

    @Override
    public DubboResult<Integer> finaExpressBlackNum(ExpressBlackListPageParams params) {
        return DubboResult.successResult(blackListService.findExpressBlackNum(params));
    }

}
