package com.qiho.center.biz.remoteservice.impl.order;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteOrderServiceImpl <br/>
 * Date: 2017年6月2日 下午7:19:03 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteOrderServiceImpl implements RemoteOrderService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteOrderServiceImpl.class);

    @Autowired
    private OrderService orderService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;
    @Autowired
    private OrderBo orderBo;

    @Override
    public DubboResult<String> submit(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        try {
            String orderId = orderService.createOrder(order, channelInfo, payType);
            return DubboResult.successResult(orderId);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.submit failed, order={}, channelInfo={}", order, channelInfo, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> sendSmsCode(String mobile, String smsCode) {
        try {
            boolean result = smsService.sendSmsCode(mobile, smsCode);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.sendSmsCode failed, mobile={}, smsCode={}", mobile, smsCode, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PagenationDto<OrderSnapshotDto>> findAllPage(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findOrderPage(params));
    }

    @Override
    public DubboResult<Integer> findAllPageCount(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findAllPageCount(params));
    }

    @Override
    public DubboResult<List<OrderSnapshotDto>> exportAllOrderPage(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findOrderPageForExport(params));
    }

    @Override
    public DubboResult<Integer> exportOrderPageCount(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.exportOrderPageCount(params));
    }

    @Override
    public DubboResult<Integer> batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        return DubboResult.successResult(orderBo.batchAuditOrder(progressKey,paramList));
    }

    @Override
    public DubboResult<Boolean> auditOrder(OrderAuditParams params) {
        try{
            return DubboResult.successResult(orderService.auditOrder(params));
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.auditOrder failed,orderId={}",params.getOrderId(), e);
            return DubboResult.failResult(e.getMessage());
        }

    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#findByOrderId(java.lang.String)
     */
    @Override
    public DubboResult<OrderDto> findByOrderId(String orderId) {
        try{
            OrderDto orderDto = orderService.findByOrderId(orderId);
            return DubboResult.successResult(orderDto);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.findByOrderId failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#findOrderSnapshot(java.lang.String)
     */
    @Override
    public DubboResult<OrderSnapshotDto> findOrderSnapshot(String orderId) {
        try{
            OrderSnapshotDto orderSnapshotDto = orderSnapshotService.findByOrderId(orderId);
            return DubboResult.successResult(orderSnapshotDto);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.findOrderSnapshot failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderItem(com.qiho.center.api.params.OrderItemParam)
     */
    @Override
    public DubboResult<Void> updateOrderItem(OrderItemParam param) {
        try{
            orderService.updateOrderItem(param);
            return DubboResult.successResult(null);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.updateOrderItem failed,param={}",param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderConsumer(com.qiho.center.api.params.OrderConsumerParam)
     */
    @Override
    public DubboResult<Void> updateOrderConsumer(OrderConsumerParam param) {
        try{
            orderService.updateOrderConsumer(param);
            return DubboResult.successResult(null);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.updateOrderConsumer failed,param={}",param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderStatus(java.lang.String, java.lang.String)
     */
    @Override
    public DubboResult<Void> updateOrderStatus(String orderId, String orderStatus) {
        try{
            orderService.updateOrderStatus(orderId, OrderStatusEnum.getByCode(orderStatus));
            return DubboResult.successResult(null);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.updateOrderStatus failed, orderId={}, orderStatus={}",orderId, orderStatus, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#findByMobile(java.lang.String)
     */
    @Override
    public DubboResult<List<OrderSnapshotDto>> findByMobile(String mobile, List<String> statusList) {
        try{
            List<OrderSnapshotDto> list = orderSnapshotService.findByMobile(mobile, statusList);
            return DubboResult.successResult(list);
        }catch(Exception e){
            LOG.error("invoke RemoteOrderService.findByMobile failed,mobile={}, statusList={}",mobile,statusList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
