package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ChannelStatusEnum;
import com.qiho.center.api.enums.ResultErrorEnum;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderStrategyService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/6/21.
 */
@Service
public class RemoteOrderStrategyServiceImpl implements RemoteOrderStrategyService {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private OrderStrategyService orderStrategyService;

    @Override
    public DubboResult<PagenationDto<OrderStrategyDto>> queryStrategyByPage(OrderStrategyParams params, Integer pageNum, Integer pageSize) {
        if (null == params)
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        List<OrderStrategyDto> resultBase = new ArrayList<>();
        PagenationDto<OrderStrategyDto> pagenationDto = new PagenationDto<>();
        try{
            if (null != params.getId()){
                OrderStrategyDto orderStrategyDto = orderStrategyService.findStrategyById(params.getId());
                if (null != orderStrategyDto){
                    resultBase.add(orderStrategyDto);
                    pagenationDto.setList(resultBase);
                    pagenationDto.setTotal(resultBase.size());
                }
            }else {
                pagenationDto = orderStrategyService.findStrategyByQuery(params,pageNum,pageSize);
            }
            return DubboResult.successResult(pagenationDto);
        }catch (Exception e){
            logger.error("踢单策略查询异常 params={} msg={}",params.toString(),e.getLocalizedMessage());
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteStrategyById(Long id) {
        if(null == id || id < 0)
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try{
            OrderStrategyDto resultDto = orderStrategyService.findStrategyById(id);
            if(null == resultDto)//id有误,需更新记录为null
                return DubboResult.failResult(ResultErrorEnum.RESULT_NULL.getMessage()+"需更删除的记录为空");
            Integer resultIte = orderStrategyService.deleteStrategyById(id);
            if (null != resultIte && resultIte > 0)
                return DubboResult.successResult(Boolean.TRUE);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("通过id删除媒体计划失败 id={}",id,e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateStrategyByParam(OrderStrategyDto orderStrategyDto) {
        if(null == orderStrategyDto || null == orderStrategyDto.getId() || StringUtils.isBlank(orderStrategyDto.getStrategyName()))
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try{
            OrderStrategyDto resultDto = orderStrategyService.findStrategyById(orderStrategyDto.getId());
            if(null == resultDto)//id有误,需更新记录为null
                return DubboResult.failResult(ResultErrorEnum.RESULT_NULL.getMessage()+"需更新数据为空");
            Integer resultBase = orderStrategyService.updateStrategy(orderStrategyDto);
            if (null != resultBase && resultBase > 0)
                return DubboResult.successResult(Boolean.TRUE);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("更新策略信息失败 orderStrategyDto={}", JSON.toJSONString(orderStrategyDto),e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> insertStrategy(OrderStrategyDto orderStrategyDto) {
        if(!valuteParams(orderStrategyDto))//校验参数
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try {
            if (null == orderStrategyDto.getStatus())
                orderStrategyDto.setStatus(ChannelStatusEnum.ONLINE.getCode());
            Integer strategyId = orderStrategyService.insertStrategy(orderStrategyDto);
            if (null != strategyId || strategyId > 0)
                return DubboResult.successResult(strategyId);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("新增策略信息失败 orderStrategyDto={}",JSON.toJSONString(orderStrategyDto),e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countByParam(OrderStrategyParams params) {
        if (null == params)
            return DubboResult.failResult("查询条件参数为空");
        try{
            Integer total = orderStrategyService.countStrategyByQuery(params);
            return DubboResult.successResult(total);
        }catch (Exception e){
            logger.error("条件查询记录数error,params={}",JSON.toJSONString(params),e);
            return DubboResult.failResult("条件查询记录数error");
        }
    }


    /**
     * 新增参数校验不为空参数,暂时分散在各个服务,之后抽取统一notnull注解校验
     */
    private Boolean valuteParams(OrderStrategyDto orderStrategyDto){
        if(null == orderStrategyDto)
            return Boolean.FALSE;
        if (null == orderStrategyDto.getHandlerName())
            return Boolean.FALSE;
        if(StringUtils.isBlank(orderStrategyDto.getStrategyName()) || StringUtils.isBlank(orderStrategyDto.getCreator()))
            return Boolean.FALSE;
        return Boolean.TRUE;
    }
}
