package com.qiho.center.biz.service;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.params.BandParams;

import java.util.List;

/**
 * Created by liuyao on 2017/5/24.
 */
public interface BandService {

    /**
     * 获取所有的Band
     * @return
     */
    List<BandDto> findAllBand();

    /**
     * 保存Band
     * @param params
     */
    void saveBand(BandParams params);

    /**
     * 切换BAND的启用开关
     * @param id
     * @return
     */
    Boolean changeBandShowEnable(Long id);

    /**
     * 对Band进行排序
     * @param bandIds
     * @return
     */
    Integer sortBand(List<Long> bandIds);

    /**
     * 删除Band
     * @param id
     * @return
     */
    Integer deleteBand(Long id);
}
