package com.qiho.center.biz.service;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.ChannelDto;
import com.qiho.center.api.params.ChannelParams;
import com.qiho.center.common.entity.campaign.QihoChannelEntity;

import java.util.List;

/**
 * Created by danke on 2017/6/16.
 * 渠道的service
 */
public interface ChannelService {

    /**
     * 通过id查询
     * @param id
     * @return
     */
    ChannelDto findById(Long id);

    /**
     * 通过条件查询
     * @param params
     * @return
     */
    PagenationDto<ChannelDto> findByQuery(ChannelParams params,Integer pageNum,Integer pageSize);

    /**
     * 更新渠道
     * @param channelDto
     * @return
     */
    Integer updateChannel(ChannelDto channelDto);

    /**
     * 通过id删除指定渠道,级联删除媒体计划,在业务层处理
     * @param id
     * @return
     */
    Integer deleteChannelById(Long id);

    /**
     * 新增渠道
     * @param channelDto
     * @return
     */
    Integer insertChannel(ChannelDto channelDto);

    /**
     * 通过条件查询记录数
     */
    Integer countChannelByQuery(ChannelParams params);

}
