/**
 * Project Name:qiho-center-biz
 * File Name:ItemSkuService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月20日下午6:00:34
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import java.util.List;

import com.qiho.center.api.dto.ItemSkuDto;

/**
 * ClassName:ItemSkuService <br/>
 * 商品SKU服务接口. <br/>
 * Date:     2017年5月20日 下午6:00:34 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemSkuService {

    /**
     * 根据商品ID查询SKU列表
     * @author zhanglihui
     * @param itemId
     * @return List<ItemSkuDto>
     */
    List<ItemSkuDto> getSkuByItemId(Long itemId);

    /**
     * 全量更新
     *
     * @author zhanglihui
     * @param skuList
     * @param itemId
     */
    void updateItemSku(List<ItemSkuDto> skuList, Long itemId);

    /**
     * 根据skuId查询sku信息
     * @author zhanglihui
     * @param skuId
     * @return ItemSkuDto
     */
    ItemSkuDto querySku(Long skuId);
}

