/**
 * Project Name:qiho-center-biz
 * File Name:TemplateServiceImpl.java
 * Package Name:com.qiho.center.biz.service.impl
 * Date:2017年6月21日上午9:44:36
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.TemplateDto;
import com.qiho.center.biz.service.TemplateService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;


/**
 * ClassName:TemplateServiceImpl <br/>
 * Date:     2017年6月21日 上午9:44:36 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class TemplateServiceImpl implements TemplateService {
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    
    @Override
    public void enableSwitch(Long id, Boolean enable) {

        qihoTemplateDAO.updateEnableById(id, enable);

    }

    /**
     * @see com.qiho.center.biz.service.TemplateService#addTemplate(java.lang.String, java.lang.String, java.lang.String)
     */
    @Override
    public void addTemplate(String templateCode, String templateName, String templateContext) {
        QihoTemplateEntity qihoTemplateEntity = new QihoTemplateEntity();
        qihoTemplateEntity.setTemplateCode(templateCode);
        qihoTemplateEntity.setTemplateContext(templateContext);
        qihoTemplateEntity.setTemplateEnable(true);
        qihoTemplateEntity.setTemplateName(templateName);
        qihoTemplateDAO.insert(qihoTemplateEntity);
    }

    /**
     * @see com.qiho.center.biz.service.TemplateService#updateTemplate(java.lang.Long, java.lang.String)
     */
    @Override
    public void updateTemplate(Long id, String templateContext) {
        qihoTemplateDAO.updateById(id, templateContext);
    }

    /**
     * @see com.qiho.center.biz.service.TemplateService#findTemplateList()
     */
    @Override
    public List<TemplateDto> findTemplateList() {
        List<QihoTemplateEntity> list = qihoTemplateDAO.findAll();
        return BeanUtils.copyList(list, TemplateDto.class);
    }

}

