/**
 * Project Name:qiho-center-biz File Name:YtoQueryProcessor.java Package Name:com.qiho.center.biz.service.logistics
 * Date:2017年8月10日下午3:34:19 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.service.logistics;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams.Result;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams.Result.WaybillCode;
import com.qiho.center.common.params.YTOLogisticProcessParams;
import com.qiho.center.common.params.YTOLogisticProcessParams.Result.LogisticDetail;
import com.qiho.center.common.util.JaxbUtil;
import com.qiho.center.common.util.YTOClientUtil;

/**
 * ClassName:YtoQueryProcessor <br/>
 * 圆通速递查询处理器. <br/>
 * Date: 2017年8月10日 下午3:34:19 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class YtoQueryProcessor implements LogisticsQueryProcessor, InitializingBean {

    private static final Logger LOG               = LoggerFactory.getLogger(YtoQueryProcessor.class);
    private static final String YTO_FAILED_RETURN = "<success>false</success>";

    @Override
    public List<LogisticsProcessDto> queryWaybillTrace(String postId) {
        List<LogisticsProcessDto> list = Lists.newArrayList();
        if (StringUtils.isBlank(postId)) {
            return list;
        }
        QueryYTOLogisticProcessParams queryXml = new QueryYTOLogisticProcessParams(new Result(new WaybillCode(postId)));
        try {
            // 请求查询走件流程
            String logisticsString = YTOClientUtil.execute(YTOClientUtil.getQueryLogisticsUrl(), queryXml);
            // 结果返回
            if (StringUtils.isNotBlank(logisticsString) && !StringUtils.contains(logisticsString, YTO_FAILED_RETURN)) {
                YTOLogisticProcessParams returnLogistics = JaxbUtil.converyToJavaBean(logisticsString,
                                                                                      YTOLogisticProcessParams.class);
                if (returnLogistics != null) {
                    List<LogisticDetail> logisticDetail = returnLogistics.getResult().getLogisticDetail();
                    list = BeanUtils.copyList(logisticDetail, LogisticsProcessDto.class);
                }
            }
            // 倒序排序
            if (CollectionUtils.isNotEmpty(list)) {
                Collections.reverse(list);
            }
        } catch (Exception e) {
            LOG.warn("查询圆通快递运单走件流程异常， postId="+postId, e);
        }
        return list;
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        LogisticsQueryDecider.registLogisticsQueryProcessor(LogisticsNameEnum.YTO, this);
    }

}
