/**
 * Project Name:qiho-center-biz
 * File Name:SmsService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月3日下午12:02:19
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import com.qiho.center.common.enums.SmsTemplateEnum;

/**
 * ClassName:SmsService <br/>
 * 短信服务. <br/>
 * Date:     2017年6月3日 下午12:02:19 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface SmsService {

    /**
     * 发送短信验证码，用于下单校验
     * @author zhanglihui
     * @param mobile 手机号码
     * @param smsCode 验证码
     * @return 是否发送成功
     */
    boolean sendSmsCode(String mobile, String smsCode);

    /**
     * 发送短信
     *
     * @author zhanglihui
     * @param text   短信内容 {@link SmsTemplateEnum}
     * @param mobile 手机号码
     * @return 是否发送成功
     */
    boolean singleSend(String text, String mobile);
}

