package com.qiho.center.biz.service.statistics;

import java.util.List;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.statistics.QueryStatisticsDayDto;
import com.qiho.center.api.dto.statistics.StatisticsDayDto;
import com.qiho.center.api.params.ExportStatisticsDayParams;


/**
 * ClassName: StatisticsDayService <br/>
 * date: 2017年6月6日 下午12:50:55 <br/>
 *
 */
public interface StatisticsDayService {

    /**
     * 分页查询统计数据
     *
     * @author chencheng
     * @param queryDto 
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<StatisticsDayDto>
     */
    PagenationDto<StatisticsDayDto> queryStatisticsDayPage(QueryStatisticsDayDto queryDto, Integer pageNum,
                                                             Integer pageSize);

    /**
     * 根据日期查询所有统计数据个数
     *
     * @author chencheng
     * @param queryDto
     * @return
     */
    Integer findAllStatisticsDayCount(ExportStatisticsDayParams queryDto);

    /**
     * 根据日期查询统计数据
     *
     * @author chencheng
     * @param params
     * @return
     */
    List<StatisticsDayDto> queryAllStatisticsDay(ExportStatisticsDayParams params);

}
