/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.biz.runnable.BlackListRunnable;
import com.qiho.center.biz.runnable.ExpressBlackListRunnable;
import com.qiho.center.biz.service.BlackListService;
import com.qiho.center.biz.service.order.AnticheateService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class BlackListBo
implements ApplicationContextAware {
    private ApplicationContext context;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private BlackListService blackListService;
    @Autowired
    private OrderService orderService;
    @Resource
    private AnticheateService anticheateService;

    public Integer batchBlackList(String progressKey, List<BlackListOperationParams> paramList) {
        BlackListRunnable runnable = (BlackListRunnable)this.context.getBean(BlackListRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return enableCount;
    }

    public Integer batchExpressBlackList(String progressKey, List<ExpressBlackListOperationParams> paramsList) {
        ExpressBlackListRunnable runnable = (ExpressBlackListRunnable)this.context.getBean(ExpressBlackListRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramsList);
        int enableCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return enableCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void cheatProof(String orderId) {
        OrderDto orderDto = this.orderService.findByOrderId(orderId);
        if (orderDto == null) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(this.phoneBlack(orderDto));
        list.addAll(this.areaBlack(orderDto));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (QihoAnticheateEntity qihoAnticheateEntity2 : list) {
                if (null == qihoAnticheateEntity2) continue;
                this.anticheateService.insert(qihoAnticheateEntity2);
            }
        }
    }

    private List<QihoAnticheateEntity> phoneBlack(OrderDto orderDto) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)orderDto.getMobile())) {
            BlackListDto manualPhoneDto = this.blackListService.findOneBlacklist(QueryBlackListTypeEnum.MANUAL_PHONE_NUMBER, orderDto.getMobile());
            if (manualPhoneDto != null) {
                list.add(new QihoAnticheateEntity(orderDto.getOrderId(), QueryBlackListTypeEnum.MANUAL_PHONE_NUMBER.getDesc()));
            }
            BlackListDto blackListDto = this.blackListService.findLatestDateByType(QueryBlackListTypeEnum.STRATEGY_PHONE_NUMBER);
            BlackListDto strategyPhoneDto = null;
            if (null != blackListDto) {
                strategyPhoneDto = this.blackListService.findOneBlacklist(QueryBlackListTypeEnum.STRATEGY_PHONE_NUMBER, orderDto.getMobile(), blackListDto.getCurDate());
            }
            if (strategyPhoneDto != null) {
                list.add(new QihoAnticheateEntity(orderDto.getOrderId(), QueryBlackListTypeEnum.STRATEGY_PHONE_NUMBER.getDesc()));
            }
        }
        return list;
    }

    private List<QihoAnticheateEntity> areaBlack(OrderDto orderDto) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)orderDto.getAreaNum())) {
            BlackListDto manualRegionDto = this.blackListService.findOneBlacklist(QueryBlackListTypeEnum.MANUAL_REGION, orderDto.getAreaNum());
            if (manualRegionDto != null) {
                list.add(new QihoAnticheateEntity(orderDto.getOrderId(), QueryBlackListTypeEnum.MANUAL_REGION.getDesc()));
            }
            BlackListDto blackListDto = this.blackListService.findLatestDateByType(QueryBlackListTypeEnum.STRATEGY_REGION);
            BlackListDto strategyRegionDto = null;
            if (null != blackListDto) {
                strategyRegionDto = this.blackListService.findOneBlacklist(QueryBlackListTypeEnum.STRATEGY_REGION, orderDto.getMobile(), blackListDto.getCurDate());
            }
            if (strategyRegionDto != null) {
                list.add(new QihoAnticheateEntity(orderDto.getOrderId(), QueryBlackListTypeEnum.STRATEGY_REGION.getDesc()));
            }
        }
        return list;
    }
}

