/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoOrderItemInfoDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderItemInfoEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.ERPClientUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@BizEventListener
public class ErpOrderBo {
    private static final Logger LOG = LoggerFactory.getLogger(ErpOrderBo.class);
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private OrderBo orderBo;
    @Autowired
    private OrderService orderService;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoOrderItemInfoDAO qihoOrderItemInfoDAO;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Autowired
    private FundOrderService fundOrderService;
    @Resource
    private ExecutorService executorService;
    @Value(value="${qiho.erp.shop.no}")
    private String shopNo;
    @Value(value="${qiho.erp.auto.reliver.url}")
    private String erpAutoReliverUrl;
    private ListeningExecutorService service;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)this.executorService);
    }

    @Transactional(value="QIHO")
    public void cancelDeliver(String erpId) {
        ErpOrderDto erpOrderDto = this.erpOrderService.updateErpStatus(erpId, ErpStatusEnum.FAILED, ErpStatusEnum.TO_NOTIFY, "\u53d6\u6d88\u53d1\u8d27");
        if (Objects.equal((Object)erpOrderDto.getErpType(), (Object)ErpTypeEnum.SEND.getCode())) {
            this.orderBo.rejectOrder(erpOrderDto.getOrderId(), "ERP\u5b50\u8ba2\u5355\u901a\u77e5\u5931\u8d25", null);
        }
        this.refund(erpOrderDto.getOrderId());
    }

    private void refund(String orderId) {
        List<FundOrderDto> list = this.fundOrderService.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isEmpty(list)) {
            throw new QihoException("\u6570\u636e\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId=" + orderId);
        }
        FundOrderDto fundOrder = list.get(0);
        if (StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
            fundOrder.setFundStatus(FundStatusEnum.FAILED.getCode());
            this.fundOrderService.update(fundOrder);
            QihoOrderSnapshotEntity order = new QihoOrderSnapshotEntity();
            order.setOrderId(orderId);
            order.setFundStatus(FundStatusEnum.FAILED.getCode());
            this.qihoOrderSnapshotDAO.updataFundInfo(order);
        } else if (!StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) && StringUtils.equals((CharSequence)fundOrder.getFundStatus(), (CharSequence)FundStatusEnum.SUCCESS.getCode())) {
            this.fundOrderService.refund(fundOrder.getOrderId(), fundOrder.getPayType(), fundOrder.getAmt());
        }
    }

    @Transactional(value="QIHO")
    public void resolveDeliver(ResolveDeliverParams params) {
        ErpOrderDto erpOrderDto = this.erpOrderService.updateErpStatus(params.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
        this.logisticsOrderService.initLogisticsOrder(erpOrderDto, params);
    }

    public void autoDelivery(QihoErpOrderEntity erp) {
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(erp.getOrderId());
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode())) {
            AppLogUtil.warn((Logger)LOG, (String)"\u8ba2\u5355\u975e\u4ee3\u53d1\u8d27\u72b6\u6001\uff0c\u3010orderId={}, orderStatus={}\u3011", (Object[])new Object[]{order.getOrderId(), order.getOrderStatus()});
            return;
        }
        AutoErpReliverRunnable runnable = new AutoErpReliverRunnable();
        runnable.setQihoErpOrderEntity(erp);
        runnable.setQihoOrderSnapshotEntity(order);
        AutoErpReliverFutureCallback callback = new AutoErpReliverFutureCallback();
        callback.setQihoErpOrderEntity(erp);
        ListenableFuture future = this.service.submit((Callable)runnable);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)callback);
    }

    @Transactional(value="QIHO")
    public Integer reviewFaildErpOrder(ErpOrderDto dto) {
        LogisticsOrderDto logisticsOrderDto = this.logisticsOrderService.findByErpId(dto.getErpId());
        if (logisticsOrderDto != null) {
            return 0;
        }
        ErpOrderDto updatedto = this.erpOrderService.updateErpStatus(dto.getErpId(), ErpStatusEnum.FAILED, ErpStatusEnum.SUCCESS, dto.getFailedMessage());
        if (updatedto == null) {
            return 0;
        }
        this.orderBo.rejectOrder(updatedto.getOrderId(), dto.getFailedMessage(), OrderApprovalStatusEnum.APPROVE_FAILD);
        this.refund(updatedto.getOrderId());
        return 1;
    }

    private class AutoErpReliverFutureCallback
    implements FutureCallback<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;

        private AutoErpReliverFutureCallback() {
        }

        public void onSuccess(JSONObject result) {
            if (result.getInteger("code") != 0) {
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.FAILED, ErpStatusEnum.TO_NOTIFY, "ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25");
                LOG.error("ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25:" + result.getString("message"));
            } else {
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            }
        }

        public void onFailure(Throwable t) {
            LOG.error("ERP\u8ba2\u5355\u81ea\u52a8\u53d1\u8d27\u8bf7\u6c42\u5931\u8d25,ERP={}", (Object)this.qihoErpOrderEntity.getErpId(), (Object)t);
        }

        public void setQihoErpOrderEntity(QihoErpOrderEntity qihoErpOrderEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
        }
    }

    private class AutoErpReliverRunnable
    implements Callable<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;
        private QihoOrderSnapshotEntity qihoOrderSnapshotEntity;

        private AutoErpReliverRunnable() {
        }

        @Override
        public JSONObject call() {
            Map<String, String> params = this.getParams();
            String result = ERPClientUtil.execute((String)ErpOrderBo.this.erpAutoReliverUrl, params);
            return JSONObject.parseObject((String)result);
        }

        public void setQihoErpOrderEntity(QihoErpOrderEntity qihoErpOrderEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
        }

        public void setQihoOrderSnapshotEntity(QihoOrderSnapshotEntity qihoOrderSnapshotEntity) {
            this.qihoOrderSnapshotEntity = qihoOrderSnapshotEntity;
        }

        private Map<String, String> getParams() {
            HashMap parmas = Maps.newHashMap();
            parmas.put("shop_no", ErpOrderBo.this.shopNo);
            JSONArray tradeList = new JSONArray();
            JSONObject tradeItem = new JSONObject();
            tradeItem.put("tid", (Object)this.qihoErpOrderEntity.getErpId());
            tradeItem.put("trade_status", (Object)30);
            int payStatus = 0;
            int deliveryTerm = 2;
            float codAmount = (float)this.qihoOrderSnapshotEntity.getOrderAmt().intValue() / 100.0f;
            float paid = 0.0f;
            if (!StringUtils.equals((CharSequence)this.qihoOrderSnapshotEntity.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
                payStatus = 2;
                deliveryTerm = 1;
                codAmount = 0.0f;
                paid = (float)this.qihoOrderSnapshotEntity.getOrderAmt().intValue() / 100.0f;
            }
            tradeItem.put("pay_status", (Object)payStatus);
            tradeItem.put("delivery_term", (Object)deliveryTerm);
            tradeItem.put("trade_time", (Object)DateUtils.getSecondStr((Date)this.qihoErpOrderEntity.getGmtCreate()));
            tradeItem.put("buyer_nick", (Object)this.qihoErpOrderEntity.getConsumerName());
            tradeItem.put("receiver_name", (Object)this.qihoErpOrderEntity.getConsumerName());
            tradeItem.put("receiver_province", (Object)this.qihoErpOrderEntity.getProvince());
            tradeItem.put("receiver_city", (Object)this.qihoErpOrderEntity.getCity());
            tradeItem.put("receiver_district", (Object)this.qihoErpOrderEntity.getDistrict());
            tradeItem.put("receiver_address", (Object)this.qihoErpOrderEntity.getAddress());
            tradeItem.put("receiver_mobile", (Object)this.qihoErpOrderEntity.getMobile());
            tradeItem.put("logistics_type", (Object)4);
            tradeItem.put("buyer_message", (Object)this.qihoOrderSnapshotEntity.getMessage());
            tradeItem.put("post_amount", (Object)0);
            tradeItem.put("cod_amount", (Object)Float.valueOf(codAmount));
            tradeItem.put("ext_cod_fee", (Object)0);
            tradeItem.put("other_amount", (Object)0);
            tradeItem.put("paid", (Object)Float.valueOf(paid));
            JSONArray orderList = new JSONArray();
            JSONObject orderItem = new JSONObject();
            QihoOrderItemInfoEntity orderItemInfo = ErpOrderBo.this.qihoOrderItemInfoDAO.findByOrderId(this.qihoOrderSnapshotEntity.getOrderId());
            orderItem.put("oid", (Object)(this.qihoErpOrderEntity.getErpId() + "-1"));
            orderItem.put("num", (Object)orderItemInfo.getQuantity());
            orderItem.put("price", (Object)Float.valueOf((float)orderItemInfo.getSellingPrice().intValue() / 100.0f));
            orderItem.put("status", (Object)10);
            orderItem.put("refund_status", (Object)0);
            orderItem.put("goods_id", (Object)orderItemInfo.getItemId());
            orderItem.put("spec_id", (Object)orderItemInfo.getSkuId());
            orderItem.put("goods_no", (Object)orderItemInfo.getItemNo());
            orderItem.put("goods_name", (Object)orderItemInfo.getItemName());
            orderItem.put("spec_no", (Object)orderItemInfo.getSkuNo());
            orderItem.put("spec_name", (Object)orderItemInfo.getSkuName());
            orderItem.put("cid", (Object)1);
            orderList.add((Object)orderItem);
            tradeItem.put("order_list", (Object)orderList);
            tradeList.add((Object)tradeItem);
            parmas.put("trade_list", tradeList.toJSONString());
            return parmas;
        }
    }
}

