/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.ERPClientUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SyncStockBo {
    private static final Logger logger = LoggerFactory.getLogger(SyncStockBo.class);
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private OrderStockService orderStockService;
    @Value(value="${qiho.erp.warehouse.no}")
    private String warehouseNo;
    private static final String pageSize = "100";
    @Value(value="${qiho.erp.stock.query.url}")
    private String erpStockQueryUrl;

    public void syncStock() {
        int curPageNo = 0;
        ArrayList increaseStock = Lists.newArrayList();
        ArrayList descreaseStock = Lists.newArrayList();
        while (true) {
            Map<String, String> params = this.getParams(curPageNo);
            String result = ERPClientUtil.execute((String)this.erpStockQueryUrl, params);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String code = jsonObject.getString("code");
            if (ErpErrorCodeReturnEnum.SUCCESS.getCode().equals(code)) {
                result = jsonObject.getString("stocks");
                List stocks = JSONArray.parseArray((String)result, ErpStock.class);
                if (stocks.isEmpty()) break;
                this.orderStockService.handlerErpStocks(increaseStock, descreaseStock, stocks);
            }
            ++curPageNo;
        }
        DubboResult incResult = this.remoteStockBackendService.increaseItemStockBatch((List)increaseStock);
        DubboResult desResult = this.remoteStockBackendService.decreaseItemStockBatch((List)descreaseStock);
        if (!incResult.isSuccess() || !desResult.isSuccess()) {
            logger.warn("\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a{},{}", (Object)incResult.getMsg(), (Object)desResult.getMsg());
        }
        logger.warn("\u5e93\u5b58\u540c\u6b65:\u5171{}\u9875\u6570\u636e\uff0c\u6bcf\u9875100\u6761", (Object)curPageNo);
    }

    private Map<String, String> getParams(long pageNo) {
        HashMap parmas = Maps.newHashMap();
        parmas.put("end_time", DateUtils.getSecondStr((Date)new Date()));
        parmas.put("page_no", Long.toString(pageNo));
        parmas.put("page_size", pageSize);
        parmas.put("warehouse_no", this.warehouseNo);
        return parmas;
    }
}

