/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyCheckResultDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.impl.BaseOrderEngine;
import com.qiho.center.common.enums.InnerLogTypeEnum;
import com.qiho.center.common.log.InnerLog;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AheadPreventOrderEngine
extends BaseOrderEngine
implements BaseEngine<StrategyCheckResultDto> {
    private Logger logger = LoggerFactory.getLogger(AheadPreventOrderEngine.class);
    private BaseHandler baseHandler;

    @Override
    public StrategyCheckResultDto process(StrategyCheckResultDto result) {
        if (null == result || null == result.getOrderSnapshotDto()) {
            return result;
        }
        result.setSuccess(true);
        try {
            List<OrderStrategyDto> orderStrategyDtos = this.getOrderStrategyList(StrategyType.AHEAD_PREVENT_ORDER);
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                return result;
            }
            return this.checkStrategy(result, orderStrategyDtos);
        }
        catch (Exception e) {
            this.logger.error("\u7b56\u7565\u8fc7\u6ee4\u94fe\u8def\u5931\u8d25, data={}", (Object)result.toString(), (Object)e);
            return result;
        }
    }

    private StrategyCheckResultDto checkStrategy(StrategyCheckResultDto result, List<OrderStrategyDto> orderStrategyDtos) {
        for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
            Boolean flag = Boolean.TRUE;
            ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
            if (!resultBase.hasSuccessValue()) {
                this.logger.warn(resultBase.getErrorMsg());
                continue;
            }
            List strategyRuleDtos = (List)resultBase.getValue();
            ProcessContext processContext = null;
            for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                try {
                    processContext = ProcessFaceory.createProcessContext(result.getOrderSnapshotDto(), strategyRuleDto, orderStrategyDto);
                    ResultBase<Boolean> checkResult = this.baseHandler.handleRequest(processContext);
                    if (checkResult.hasSuccessValue()) {
                        flag = flag != false && (Boolean)checkResult.getValue() != false;
                        continue;
                    }
                    flag = Boolean.FALSE;
                    this.logger.warn("\u672c\u6761\u7b56\u7565\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
                    break;
                }
                catch (Exception e) {
                    throw new QihoException("\u7b56\u7565\u6267\u884c\u5f02\u5e38", (Throwable)e);
                }
            }
            if (!flag.booleanValue()) continue;
            JSONObject logInfo = new JSONObject();
            logInfo.put("order", (Object)result.getOrderSnapshotDto());
            logInfo.put("rule", (Object)orderStrategyDto);
            InnerLog.log((InnerLogTypeEnum)InnerLogTypeEnum.SUBMIT_ORDER_RULE, (Object)logInfo);
            result.setSuccess(false);
            result.setShotOrderHandlerEnum(ShotOrderHandlerEnum.fromVal((String)orderStrategyDto.getHandlerName()));
            return result;
        }
        return result;
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}

