/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseOrderEngine {
    @Resource
    OrderStrategyService orderStrategyService;
    @Resource
    private OrderService orderService;

    public List<OrderStrategyDto> getOrderStrategyList(StrategyType strategyType) {
        OrderStrategyParams params = new OrderStrategyParams();
        params.setStrategyType(Integer.valueOf(strategyType.getCode()));
        List orderStrategyDtos = this.orderStrategyService.findStrategyByQuery(params, null, null).getList();
        return orderStrategyDtos;
    }

    protected ResultBase<List<StrategyRuleDto>> validateorderStrategyDto(OrderStrategyDto orderStrategyDto) {
        ResultBase resultBase = new ResultBase();
        if (StringUtils.isBlank((CharSequence)orderStrategyDto.getRulevalue())) {
            return resultBase.setErrorReturn("\u7b56\u7565\u4e3a\u7a7a,\u4e0d\u6821\u9a8c");
        }
        List strategyRuleDtos = JSONObject.parseArray((String)orderStrategyDto.getRulevalue(), StrategyRuleDto.class);
        if (CollectionUtils.isEmpty((Collection)strategyRuleDtos)) {
            return resultBase.setErrorReturn("\u6b64\u7b56\u7565\u7684\u7b56\u7565\u89c4\u5219\u503c\u4e3a\u7a7a,\u4e0d\u6821\u9a8c strategyName=" + orderStrategyDto.getStrategyName());
        }
        return resultBase.setRightReturn((Object)strategyRuleDtos);
    }

    protected void auditOrderPass(String orderId) {
        OrderAuditParams params = new OrderAuditParams();
        params.setOrderId(orderId);
        params.setAuditResult(Integer.valueOf(1));
        this.orderService.auditOrder(params);
    }
}

