/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.impl.BaseOrderEngine;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.FixedOrderComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShotOrderEngine
extends BaseOrderEngine
implements BaseEngine<OrderSnapshotDto> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, BaseEngine> strategyTask;
    private BaseHandler baseHandler;

    @Override
    public OrderSnapshotDto process(OrderSnapshotDto valuteData) {
        if (null == valuteData) {
            return valuteData;
        }
        boolean isHit = false;
        try {
            List<OrderStrategyDto> orderStrategyDtos = this.getOrderStrategyList(StrategyType.SHOT_ORDER);
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                this.auditOrderPass(valuteData.getOrderId());
                return valuteData;
            }
            this.sortList(orderStrategyDtos);
            for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
                Boolean flag = Boolean.TRUE;
                ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
                if (!resultBase.hasSuccessValue()) {
                    this.logger.warn(resultBase.getErrorMsg());
                    continue;
                }
                List strategyRuleDtos = (List)resultBase.getValue();
                ProcessContext processContext = null;
                for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                    processContext = ProcessFaceory.createProcessContext(valuteData, strategyRuleDto, orderStrategyDto);
                    ResultBase<Boolean> checkResult = this.baseHandler.handleRequest(processContext);
                    if (checkResult.hasSuccessValue()) {
                        flag = flag != false && (Boolean)checkResult.getValue() != false;
                        continue;
                    }
                    flag = Boolean.FALSE;
                    this.logger.warn("\u672c\u6761\u7b56\u7565\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
                    break;
                }
                if (!flag.booleanValue() || null == this.strategyTask) continue;
                BaseEngine baseEngine = this.strategyTask.get(orderStrategyDto.getHandlerName());
                if (null != baseEngine) {
                    baseEngine.process(processContext);
                }
                isHit = true;
                if (null == processContext || !processContext.getNeedBroken().booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("\u7b56\u7565\u8fc7\u6ee4\u94fe\u8def\u5931\u8d25, data={}", (Object)valuteData.toString(), (Object)e);
        }
        if (!isHit) {
            this.auditOrderPass(valuteData.getOrderId());
        }
        return valuteData;
    }

    private void sortList(List<OrderStrategyDto> orderStrategyDtos) {
        Object[] shotOrderHandler = new String[]{ShotOrderHandlerEnum.AUDIT_REJECT.getVal(), ShotOrderHandlerEnum.STAMP.getVal()};
        FixedOrderComparator typeComparator = new FixedOrderComparator(shotOrderHandler);
        ComparatorChain moInfoComparator = new ComparatorChain();
        moInfoComparator.addComparator((Comparator)new BeanComparator("handlerName", (Comparator)typeComparator));
        Collections.sort(orderStrategyDtos, moInfoComparator);
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public Map<String, BaseEngine> getStrategyTask() {
        return this.strategyTask;
    }

    public void setStrategyTask(Map<String, BaseEngine> strategyTask) {
        this.strategyTask = strategyTask;
    }
}

