/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.util.StringRandUtil;
import com.qiho.center.api.util.WechatPayAppUtil;
import com.qiho.center.api.util.XmlTranformUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.WechatPayBaseProcessor;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class WechatPayOfficialAccountProcessor
extends WechatPayBaseProcessor
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(WechatPayOfficialAccountProcessor.class);
    private static String SUFFIX = "p";

    public void afterPropertiesSet() throws Exception {
        PayChannelDecider.registPaychannel(PayTypeEnum.WECHATPAY_PUB, this);
    }

    @Override
    public String payExecute(String orderId, Map<String, String> params) {
        HashMap map = Maps.newHashMap();
        try {
            Map<String, String> data = this.buildPayParams(orderId, params);
            String parmaStr = XmlTranformUtil.mapToXml(data);
            String httpResultStr = HttpClientUtil.postData((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)parmaStr);
            Map resultMap = XmlTranformUtil.xmlToMap((String)httpResultStr);
            if ("SUCCESS".equals(resultMap.get("return_code")) && "SUCCESS".equals(resultMap.get("result_code"))) {
                map.put("appId", resultMap.get("appid"));
                map.put("nonceStr", resultMap.get("nonce_str"));
                map.put("signType", "MD5");
                map.put("package", "prepay_id=" + (String)resultMap.get("prepay_id"));
                map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
                map.put("paySign", this.sign(map, WechatPayAppUtil.getSecret()));
                return JSON.toJSONString((Object)map);
            }
            AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,orderId = {},\u8fd4\u56de\u62a5\u6587 = {}", (Object[])new Object[]{orderId, httpResultStr});
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u5524\u8d77\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38,orderId = {}", (Object[])new Object[]{orderId, e});
        }
        return "";
    }

    private Map<String, String> buildPayParams(String orderId, Map<String, String> params) {
        OrderDto orderDto = this.orderService.findByOrderId(orderId);
        if (null == orderDto) {
            throw new QihoException("\u65e0\u6548\u7684\u8ba2\u5355ID");
        }
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("appid", WechatPayAppUtil.getAppId());
        dataMap.put("mch_id", WechatPayAppUtil.getMchId());
        dataMap.put("nonce_str", StringRandUtil.getRandomString((int)32));
        dataMap.put("body", "\u5947\u8d27\u2014" + orderDto.getOrderItem().getItemName());
        dataMap.put("out_trade_no", orderId + SUFFIX);
        dataMap.put("total_fee", orderDto.getOrderAmt().toString());
        dataMap.put("spbill_create_ip", params.get("ip"));
        dataMap.put("notify_url", WechatPayAppUtil.getNotifyUrl());
        dataMap.put("trade_type", "JSAPI");
        dataMap.put("scene_info", "{\"h5_info\": {\"type\":\"Wap\",\"wap_url\": \"http://www.7ho.com/\",\"wap_name\": \"\u5947\u8d27\"}}");
        dataMap.put("openid", params.get("openId"));
        dataMap.put("sign", this.sign(dataMap, WechatPayAppUtil.getSecret()));
        return dataMap;
    }

    @Override
    public RefundResult refundQuery(String orderId, String fundId) {
        RefundResult result = super.refundQuery(orderId + SUFFIX, fundId);
        result.setOrderId(orderId);
        return result;
    }

    @Override
    public PayDto queryPayResult(String orderId) {
        return super.queryPayResult(orderId + SUFFIX);
    }

    @Override
    public void refund(String orderId, String fundId, Integer refundAmt) {
        super.refund(orderId + SUFFIX, fundId, refundAmt);
    }

    @Override
    PayTypeEnum getPayType() {
        return PayTypeEnum.WECHATPAY_PUB;
    }
}

