/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.campaign;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.enums.ResultErrorEnum;
import com.qiho.center.api.params.MediaPlanParams;
import com.qiho.center.api.remoteservice.campaign.RemoteMediaPlanService;
import com.qiho.center.biz.service.MediaPlanService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteMediaPlanServiceImpl
implements RemoteMediaPlanService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private MediaPlanService mediaPlanService;

    public DubboResult<PagenationDto<MediaPlanDto>> queryMediaPlanByPage(MediaPlanParams params, Integer pageNum, Integer pageSize) {
        if (null == params) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            PagenationDto<MediaPlanDto> mediaPlanPageResult = this.mediaPlanService.findByQuery(params, pageNum, pageSize);
            return DubboResult.successResult(mediaPlanPageResult);
        }
        catch (Exception e) {
            this.logger.error("\u5a92\u4f53\u8ba1\u5212\u5206\u9875\u67e5\u8be2\u5f02\u5e38 params={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> deleteMediaPlanById(Long id) {
        if (null == id || id < 0L) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            MediaPlanDto resultDto = this.mediaPlanService.findById(id);
            if (null == resultDto) {
                return DubboResult.failResult((String)"\u9700\u8981\u5220\u9664\u7684\u5a92\u4f53\u8ba1\u5212\u4e0d\u5b58\u5728");
            }
            Integer resultIte = this.mediaPlanService.deleteMediaById(id);
            if (null != resultIte && resultIte > 0) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7id\u5220\u9664\u5a92\u4f53\u8ba1\u5212\u5931\u8d25 id={}", (Object)id, (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> updateMediaPlanByParam(MediaPlanDto mediaPlanDto) {
        if (null == mediaPlanDto || null == mediaPlanDto.getId() || StringUtils.isBlank((CharSequence)mediaPlanDto.getMediaName())) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            MediaPlanDto resultDto = this.mediaPlanService.findById(mediaPlanDto.getId());
            if (null == resultDto) {
                return DubboResult.failResult((String)"\u9700\u8981\u66f4\u65b0\u7684\u5a92\u4f53\u8ba1\u5212\u4e0d\u5b58\u5728 ");
            }
            if (this.checkMediaPlanName(mediaPlanDto).booleanValue()) {
                return DubboResult.failResult((String)(ResultErrorEnum.PARAMS_ERROR.getMessage() + "\u5a92\u4f53\u8ba1\u5212\u540d\u79f0\u91cd\u590d"));
            }
            Integer resultBase = this.mediaPlanService.updateMediaPlan(mediaPlanDto);
            if (null != resultBase && resultBase > 0) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5a92\u4f53\u8ba1\u5212\u4fe1\u606f\u5931\u8d25 mediaPlanDto={}", (Object)mediaPlanDto.getId(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> insertMediaPlan(MediaPlanDto mediaPlanDto) {
        if (this.valuteParamsNull(mediaPlanDto).booleanValue()) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            if (this.checkMediaPlan(mediaPlanDto).booleanValue() || this.checkMediaPlanName(mediaPlanDto).booleanValue()) {
                return DubboResult.failResult((String)(ResultErrorEnum.PARAMS_ERROR.getMessage() + "\u5a92\u4f53\u8ba1\u5212\u540d\u79f0\u6216qiho_code\u91cd\u590d"));
            }
            Integer channelId = this.mediaPlanService.insertMediaPlan(mediaPlanDto);
            if (null != channelId || channelId > 0) {
                return DubboResult.successResult((Object)channelId);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u5a92\u4f53\u8ba1\u5212\u4fe1\u606f\u5931\u8d25 mediaPlanDto={}", (Object)mediaPlanDto.getMediaName(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> countByParam(MediaPlanParams params) {
        if (null == params) {
            return DubboResult.failResult((String)"\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            Integer total = this.mediaPlanService.countMediaPlanByQuery(params);
            return DubboResult.successResult((Object)total);
        }
        catch (Exception e) {
            this.logger.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error,params={}", (Object)JSON.toJSONString((Object)params), (Object)e);
            return DubboResult.failResult((String)"\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error");
        }
    }

    private Boolean checkMediaPlan(MediaPlanDto mediaPlanDto) {
        MediaPlanParams planParamsCode = new MediaPlanParams();
        planParamsCode.setQihoCode(mediaPlanDto.getQihoCode());
        PagenationDto<MediaPlanDto> codeResult = this.mediaPlanService.findByQuery(planParamsCode, null, null);
        if (CollectionUtils.isEmpty((Collection)codeResult.getList())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkMediaPlanName(MediaPlanDto mediaPlanDto) {
        MediaPlanParams planParamsChannel = new MediaPlanParams();
        planParamsChannel.setChannelId(mediaPlanDto.getChannelId());
        planParamsChannel.setMediaName(mediaPlanDto.getMediaName());
        PagenationDto<MediaPlanDto> channelResult = this.mediaPlanService.findByQuery(planParamsChannel, null, null);
        if (CollectionUtils.isEmpty((Collection)channelResult.getList())) {
            return Boolean.FALSE;
        }
        Long resultCopy = channelResult.getList().stream().filter(e -> mediaPlanDto.getMediaName().equals(e.getMediaName())).count();
        if (resultCopy <= 0L) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean valuteParamsNull(MediaPlanDto mediaPlanDto) {
        if (null == mediaPlanDto) {
            return Boolean.TRUE;
        }
        if (null != mediaPlanDto.getId() && mediaPlanDto.getId() > 0L) {
            return Boolean.TRUE;
        }
        if (StringUtils.isBlank((CharSequence)mediaPlanDto.getMediaName()) || StringUtils.isBlank((CharSequence)mediaPlanDto.getCreator())) {
            return Boolean.TRUE;
        }
        if (null == mediaPlanDto.getChannelId() || mediaPlanDto.getChannelId() <= 0L) {
            return Boolean.TRUE;
        }
        if (StringUtils.isBlank((CharSequence)mediaPlanDto.getChannelName())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

