/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.biz.service.order.FundOrderService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteFundOrderServiceImpl
implements RemoteFundOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFundOrderServiceImpl.class);
    @Autowired
    private FundOrderService fundOrderService;

    public DubboResult<List<FundOrderDto>> findByOrderId(String orderId) {
        try {
            List<FundOrderDto> list = this.fundOrderService.findByOrderId(orderId);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByOrderId failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PagenationDto<FundOrderDto>> queryFundPage(FundPageParam param) {
        try {
            PagenationDto<FundOrderDto> page = this.fundOrderService.queryFundPage(param);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.queryFundPage failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<FundOrderDto>> findByOrderIdAndBizType(String orderId, String bizType) {
        try {
            List<FundOrderDto> list = this.fundOrderService.findByOrderIdAndBizType(orderId, bizType);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByOrderIdAndBizType failed,orderId={},bizType={}", new Object[]{orderId, bizType, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> notifySuccess(FundOrderDto fundOrder, String originalFundStatus) {
        try {
            this.fundOrderService.notifySuccess(fundOrder, originalFundStatus);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.notifySuccess failed,fundOrder={}", (Object)fundOrder, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> refund(String orderId, String payType, Integer amt) {
        try {
            this.fundOrderService.refund(orderId, payType, amt);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.refund failed,orderId={}, payType={}, amt={}", new Object[]{orderId, payType, amt, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updatePayType(FundOrderDto fundOrder, String originalFundStatus) {
        try {
            this.fundOrderService.updatePayType(fundOrder, originalFundStatus);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.updatePayType failed,fundId={}, payType={}", new Object[]{fundOrder.getFundId(), fundOrder.getPayType(), e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<FundOrderDto> findByFundId(String fundId) {
        try {
            FundOrderDto list = this.fundOrderService.findByFundId(fundId);
            return DubboResult.successResult((Object)list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByFundId failed,fundId={}", (Object)fundId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateFundOrder(FundOrderDto fundOrder) {
        try {
            this.fundOrderService.update(fundOrder);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.updateFundOrder failed,fundOrder =>{}", (Object)JSON.toJSONString((Object)fundOrder), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

