/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.biz.bo.ErpOrderBo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BatchReviewFaildErpOrderRunnable
implements Runnable {
    private Logger LOG = LoggerFactory.getLogger(BatchReviewFaildErpOrderRunnable.class);
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<ErpOrderDto> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (ErpOrderDto param : this.params) {
                try {
                    Integer result = this.erpOrderBo.reviewFaildErpOrder(param);
                    if (result == 1) continue;
                    ++failCount;
                }
                catch (Exception e) {
                    ++failCount;
                    this.LOG.error("\u5ba1\u6838erp\u5b50\u8ba2\u5355\u4e3a\u5931\u8d25\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<ErpOrderDto> params) {
        this.params.addAll(params);
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (ErpOrderDto param : this.params) {
            if (StringUtils.isBlank((String)param.getErpId())) continue;
            newList.add(param);
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }
}

