/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.biz.service.BlackListService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BlackListRunnable
implements Runnable {
    private Logger LOG = LoggerFactory.getLogger(BlackListRunnable.class);
    @Autowired
    private BlackListService blackListService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<BlackListOperationParams> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (BlackListOperationParams param : this.params) {
                try {
                    Integer result = 0;
                    if (param.getDataType() == 1) {
                        BlackListParams blackListParams = (BlackListParams)BeanUtils.copy((Object)param, BlackListParams.class);
                        Integer count = this.blackListService.findBlackListCount(blackListParams);
                        if (count > 0) {
                            ++failCount;
                            continue;
                        }
                        result = this.blackListService.addBlackValue(param);
                    } else if (param.getDataType() == 0) {
                        result = this.blackListService.deleteByValue(param);
                    } else {
                        ++failCount;
                        continue;
                    }
                    if (result == 1) continue;
                    ++failCount;
                }
                catch (Exception e) {
                    ++failCount;
                    this.LOG.error("\u7269\u6d41\u8ba2\u5355\u7b7e\u6536\u6279\u91cf\u5931\u8d25", (Throwable)e);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<BlackListOperationParams> params) {
        this.params.addAll(params);
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (BlackListOperationParams param : this.params) {
            if (StringUtils.isBlank((String)param.getBkValue())) continue;
            newList.add(param);
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }
}

