/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BandParams;
import com.qiho.center.biz.service.BandService;
import com.qiho.center.common.dao.QihoBandDAO;
import com.qiho.center.common.entity.item.QihoBandEntity;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BandServiceImpl
implements BandService {
    @Autowired
    private QihoBandDAO qihoBandDAO;
    private Ordering ordering = Ordering.natural().reverse().onResultOf((Function)new Function<BandDto, Integer>(){

        public Integer apply(BandDto input) {
            return input.getPayload();
        }
    });

    @Override
    public List<BandDto> findAllBand() {
        List list = this.qihoBandDAO.findAllBand();
        List newList = Lists.transform((List)list, entity -> {
            BandDto dto = new BandDto();
            dto.setId(entity.getId());
            dto.setPayload(entity.getPayload());
            dto.setBandEnable(entity.isBandEnable());
            dto.setBandName(entity.getBandName());
            dto.setImage(entity.getImage());
            dto.setUrl(entity.getUrl());
            return dto;
        });
        return this.ordering.sortedCopy((Iterable)newList);
    }

    @Override
    public void saveBand(BandParams params) {
        QihoBandEntity entity = new QihoBandEntity();
        entity.setBandName(params.getBandName());
        entity.setImage(params.getImage());
        if (params.getId() == null) {
            entity.setUrl(params.getUrl());
            this.qihoBandDAO.insertBand(entity);
        } else {
            entity.setId(params.getId());
            this.qihoBandDAO.updateBandInfo(entity);
        }
    }

    @Override
    public Boolean changeBandShowEnable(Long id) {
        QihoBandEntity entity = this.qihoBandDAO.find(id);
        Boolean enable = entity.isBandEnable() == false;
        this.qihoBandDAO.changeBandShowEnable(id, enable);
        return enable;
    }

    @Override
    public Integer sortBand(List<Long> bandIds) {
        List list = this.qihoBandDAO.findAllBand();
        if (bandIds.size() != list.size()) {
            throw new QihoException("\u4f20\u5165id\u548cBand\u603b\u6570\u4e0d\u4e00\u81f4");
        }
        BandOrdering ordering = new BandOrdering();
        ordering.setBandIds(bandIds);
        list = Lists.transform((List)list, (Function)ordering);
        int count = 0;
        for (QihoBandEntity it : list) {
            int ret = this.qihoBandDAO.updatePayload(it.getId(), it.getPayload());
            count += ret;
        }
        return count;
    }

    @Override
    public Integer deleteBand(Long id) {
        return this.qihoBandDAO.deleteBand(id);
    }

    private class BandOrdering
    implements Function<QihoBandEntity, QihoBandEntity> {
        private List<Long> bandIds;
        private int maxPayload;

        private BandOrdering() {
        }

        public void setBandIds(List<Long> bandIds) {
            this.bandIds = bandIds;
            this.maxPayload = bandIds.size() - 1;
        }

        public QihoBandEntity apply(QihoBandEntity input) {
            int index = this.bandIds.indexOf(input.getId());
            input.setPayload(Integer.valueOf(this.maxPayload - index));
            return input;
        }
    }
}

