/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.biz.service.CategoryService;
import com.qiho.center.common.dao.QihoCategoryDAO;
import com.qiho.center.common.entity.item.QihoCategoryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    private QihoCategoryDAO qihoCategoryDAO;
    private static final long TOP_CATEGORY_PID = 0L;

    @Override
    @Transactional(value="QIHO")
    public void sortByRange(Long pid, Integer startPayload, Integer endPayload) {
        if (Objects.equal((Object)startPayload, (Object)endPayload)) {
            return;
        }
        List list = this.qihoCategoryDAO.findListBetweenPayload(pid.longValue(), startPayload.intValue(), endPayload.intValue());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.qihoCategoryDAO.updateByPayload(pid.longValue(), startPayload.intValue(), endPayload.intValue());
            ArrayList categoryIdList = Lists.newArrayList();
            for (QihoCategoryEntity category : list) {
                if (category.getPayload() == startPayload) continue;
                categoryIdList.add(category.getId());
            }
            int offset = 0;
            offset = startPayload > endPayload ? 1 : -1;
            this.qihoCategoryDAO.updateBatchByOffset((List)categoryIdList, offset);
        }
    }

    @Override
    public List<CategoryDto> getCategoryByPid(Long pid) {
        List list = this.qihoCategoryDAO.getCategoryByPid(pid.longValue());
        return BeanUtils.copyList((List)list, CategoryDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public void deleteCategoryById(Long categoryId) {
        int payload;
        this.qihoCategoryDAO.deleteByCategoryId(categoryId.longValue());
        QihoCategoryEntity category = this.qihoCategoryDAO.findByCategoryId(categoryId);
        if (category.getPid() != 0L && (payload = this.qihoCategoryDAO.findMaxPlayload(category.getPid())) == 0) {
            this.qihoCategoryDAO.updateCategoryIfParent(category.getPid(), false);
        }
    }

    @Override
    public void updateCategoryById(Long categoryId, String categoryName) {
        this.qihoCategoryDAO.updateCategoryById(categoryId, categoryName);
    }

    @Override
    @Transactional(value="QIHO")
    public List<CategoryDto> saveCategory(Long pid, List<String> categoryList) {
        ArrayList list = Lists.newArrayList();
        int payload = this.qihoCategoryDAO.findMaxPlayload(pid);
        if (payload == 0 && pid != 0L) {
            this.qihoCategoryDAO.updateCategoryIfParent(pid, true);
        }
        for (String categoryName : categoryList) {
            QihoCategoryEntity category = new QihoCategoryEntity();
            category.setCategoryName(categoryName);
            category.setDeleted(Boolean.valueOf(false));
            category.setIsParent(Boolean.valueOf(false));
            category.setPayload(Integer.valueOf(++payload));
            category.setPid(pid);
            list.add(category);
        }
        return BeanUtils.copyList((List)this.qihoCategoryDAO.saveCategory((List)list), CategoryDto.class);
    }
}

