/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.event.ItemDeleteEvent;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoItemRecommendDAO;
import com.qiho.center.common.entity.item.QihoItemRecommendEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@BizEventListener
public class ItemRecommendServiceImpl
implements ItemRecommendService {
    @Autowired
    private QihoItemRecommendDAO qihoItemRecommendDAO;

    @Override
    public void recommendBatch(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return;
        }
        Set existItemIds = this.qihoItemRecommendDAO.findAllRecommendItemId();
        Sets.SetView insertItems = Sets.difference((Set)Sets.newHashSet(itemIds), (Set)existItemIds);
        if (CollectionUtils.isEmpty((Collection)insertItems)) {
            return;
        }
        int payload = this.qihoItemRecommendDAO.findMaxPlayload();
        ArrayList list = Lists.newArrayList();
        for (Long itemId : insertItems) {
            QihoItemRecommendEntity entity = new QihoItemRecommendEntity();
            entity.setItemId(itemId);
            entity.setPayload(Integer.valueOf(++payload));
            list.add(entity);
        }
        this.qihoItemRecommendDAO.insertBatch((List)list);
    }

    @Override
    public List<QihoItemRecommendEntity> findAllItemRecommend() {
        return this.qihoItemRecommendDAO.findAllRecommend();
    }

    @Override
    public int deleteItemRecommend(Set<Long> itemIds) {
        ArrayList ids = Lists.newArrayList(itemIds);
        return this.qihoItemRecommendDAO.deleteItemRecommend((List)ids);
    }

    @Override
    @Transactional(value="QIHO")
    public int sortItemRecommend(List<Long> itemIds) {
        List list = this.qihoItemRecommendDAO.findAllRecommend();
        if (itemIds.size() != list.size()) {
            throw new QihoException("\u4f20\u5165id\u548c\u63a8\u8350\u5546\u54c1\u603b\u6570\u4e0d\u4e00\u81f4");
        }
        ItemRecommendOrdering ordering = new ItemRecommendOrdering();
        ordering.setOrderItemIds(itemIds);
        list = Lists.transform((List)list, (Function)ordering);
        int count = 0;
        for (QihoItemRecommendEntity it : list) {
            int ret = this.qihoItemRecommendDAO.updatePayload(it.getItemId(), it.getPayload());
            count += ret;
        }
        return count;
    }

    @Subscribe
    public void itemDeleteListener(ItemDeleteEvent event) {
        this.deleteItemRecommend(event.getItems());
    }

    private class ItemRecommendOrdering
    implements Function<QihoItemRecommendEntity, QihoItemRecommendEntity> {
        private List<Long> orderItemIds;
        private int maxPayload;

        private ItemRecommendOrdering() {
        }

        public void setOrderItemIds(List<Long> orderItemIds) {
            this.orderItemIds = orderItemIds;
            this.maxPayload = orderItemIds.size() - 1;
        }

        public QihoItemRecommendEntity apply(QihoItemRecommendEntity input) {
            int index = this.orderItemIds.indexOf(input.getItemId());
            input.setPayload(Integer.valueOf(this.maxPayload - index));
            return input;
        }
    }
}

