/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.biz.event.ItemDeleteEvent;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.biz.service.SkuPropertyService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemExtDAO;
import com.qiho.center.common.dao.QihoItemRecommendDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemExtEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.support.BizEventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemServiceImpl
implements ItemService {
    @Autowired
    private QihoItemDAO qihoItemDAO;
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private QihoItemExtDAO qihoItemExtDAO;
    @Autowired
    private QihoItemRecommendDAO qihoItemRecommendDAO;
    @Autowired
    private SkuPropertyService skuPropertyService;
    @Autowired
    private ItemSkuService itemSkuService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public PagenationDto<ItemDto> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize) {
        PagenationDto pagenation = new PagenationDto();
        QihoItemEntity param = (QihoItemEntity)BeanUtils.copy((Object)queryItem, QihoItemEntity.class);
        List list = this.qihoItemDAO.queryByParam(param, pageNum, pageSize);
        int total = this.qihoItemDAO.countByParam(param);
        pagenation.setList(this.convertToItemDto(list));
        pagenation.setTotal(Integer.valueOf(total));
        return pagenation;
    }

    private List<ItemDto> convertToItemDto(List<QihoItemDetailEntity> list) {
        ArrayList itemList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return itemList;
        }
        ArrayList idList = Lists.newArrayList();
        for (QihoItemDetailEntity entity : list) {
            idList.add(entity.getId());
        }
        List skuList = this.qihoItemSkuDAO.getSkuByItemIds((List)idList);
        ArrayList stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        HashMap itemStockMap = Maps.newHashMap();
        HashMap itemEnableStockMap = Maps.newHashMap();
        HashMap minPriceMap = Maps.newHashMap();
        HashMap minOriginalPriceMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemId;
            Long itemStock;
            Long stock = (Long)stockMap.get(skuEntity.getStockId());
            if (stock == null || stock <= 0L) {
                stock = 0L;
            }
            if ((itemStock = (Long)itemStockMap.get(itemId = skuEntity.getItemId())) == null) {
                itemStockMap.put(itemId, stock);
            } else {
                itemStockMap.put(itemId, itemStock + stock);
            }
            if (skuEntity.getSkuEnable().booleanValue()) {
                Long itemEnableStock = (Long)itemEnableStockMap.get(itemId);
                if (itemEnableStock == null) {
                    itemEnableStockMap.put(itemId, stock);
                } else {
                    itemEnableStockMap.put(itemId, itemEnableStock + stock);
                }
            }
            Integer minPrice = (Integer)minPriceMap.get(itemId);
            Integer sellingPrice = skuEntity.getSellingPrice() == null ? 0 : skuEntity.getSellingPrice();
            if (minPrice == null) {
                minPriceMap.put(itemId, sellingPrice);
            } else {
                minPriceMap.put(itemId, Math.min(minPrice, sellingPrice));
            }
            Integer minOriginalPrice = (Integer)minOriginalPriceMap.get(itemId);
            Integer originalPrice = skuEntity.getOriginalPrice() == null ? 0 : skuEntity.getOriginalPrice();
            if (minOriginalPrice == null) {
                minOriginalPriceMap.put(itemId, originalPrice);
                continue;
            }
            minOriginalPriceMap.put(itemId, Math.min(minOriginalPrice, originalPrice));
        }
        Set recommendIds = this.qihoItemRecommendDAO.findAllRecommendItemId();
        for (QihoItemDetailEntity entity : list) {
            ItemDto dto = new ItemDto();
            dto.setDeleted(entity.getDeleted());
            dto.setId(entity.getId());
            dto.setItemName(entity.getItemName());
            dto.setItemShortName(entity.getItemShortName());
            dto.setItemNo(entity.getItemNo());
            dto.setItemStatus(entity.getItemStatus());
            dto.setTopCategoryId(entity.getTopCategoryId());
            dto.setDelivery(entity.getDelivery());
            dto.setStock((Long)itemStockMap.get(entity.getId()));
            Long enableStock = (Long)itemEnableStockMap.get(entity.getId());
            if (enableStock == null) {
                dto.setEnableStock(Long.valueOf(0L));
            } else {
                dto.setEnableStock(enableStock);
            }
            dto.setMinPrice((Integer)minPriceMap.get(entity.getId()));
            dto.setMinOriginalPrice((Integer)minOriginalPriceMap.get(entity.getId()));
            dto.setIsRecommend(Boolean.valueOf(recommendIds.contains(entity.getId())));
            Map extParam = (Map)JSON.parseObject((String)entity.getExtParam(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            dto.setExtParam(extParam);
            itemList.add(dto);
        }
        return itemList;
    }

    @Override
    @Transactional(value="QIHO")
    public Long createItem(ItemDetailDto itemDetail) {
        QihoItemEntity item = (QihoItemEntity)BeanUtils.copy((Object)itemDetail, QihoItemEntity.class);
        item.setDeleted(Boolean.valueOf(false));
        this.qihoItemDAO.insert(item);
        Long itemId = item.getId();
        QihoItemExtEntity itemExt = new QihoItemExtEntity();
        itemExt.setDetail(itemDetail.getDetail());
        itemExt.setExtParam(JSON.toJSONString((Object)itemDetail.getExtParam()));
        itemExt.setItemId(itemId);
        this.qihoItemExtDAO.insert(itemExt);
        List propertyList = itemDetail.getSkuPropertyList();
        this.skuPropertyService.updateItemId(propertyList, itemId);
        this.skuPropertyService.enableProperty(propertyList, itemId);
        this.itemSkuService.updateItemSku(itemDetail.getSkuList(), itemId);
        return itemId;
    }

    @Override
    @Transactional(value="QIHO")
    public void updateItem(ItemDetailDto itemDetail) {
        QihoItemEntity item = (QihoItemEntity)BeanUtils.copy((Object)itemDetail, QihoItemEntity.class);
        this.qihoItemDAO.update(item);
        Long itemId = itemDetail.getId();
        QihoItemExtEntity itemExt = new QihoItemExtEntity();
        itemExt.setDetail(itemDetail.getDetail());
        itemExt.setExtParam(JSON.toJSONString((Object)itemDetail.getExtParam()));
        itemExt.setItemId(itemId);
        this.qihoItemExtDAO.updateByItemId(itemExt);
        List propertyList = itemDetail.getSkuPropertyList();
        this.skuPropertyService.updateItemId(propertyList, itemId);
        this.skuPropertyService.enableProperty(propertyList, itemId);
        this.itemSkuService.updateItemSku(itemDetail.getSkuList(), itemId);
    }

    @Override
    public ItemDetailDto queryItemDetail(Long itemId) {
        QihoItemDetailEntity qihoItemDetailEntity = this.qihoItemDAO.findById(itemId);
        if (qihoItemDetailEntity == null) {
            return null;
        }
        ItemDto itemDto = this.convertToItemDto(Lists.newArrayList((Object[])new QihoItemDetailEntity[]{qihoItemDetailEntity})).get(0);
        ItemDetailDto itemDetailDto = (ItemDetailDto)BeanUtils.copy((Object)itemDto, ItemDetailDto.class);
        itemDetailDto.setDetail(qihoItemDetailEntity.getDetail());
        itemDetailDto.setPriceText(qihoItemDetailEntity.getPriceText());
        itemDetailDto.setGmtCreator(qihoItemDetailEntity.getGmtCreator());
        itemDetailDto.setGmtModifier(qihoItemDetailEntity.getGmtModifier());
        itemDetailDto.setGmtModified(qihoItemDetailEntity.getGmtModified());
        itemDetailDto.setSkuPropertyList(this.skuPropertyService.getSkuPropertyByItemId(itemId));
        itemDetailDto.setSkuList(this.itemSkuService.getSkuByItemId(itemId));
        itemDetailDto.setDeleted(qihoItemDetailEntity.getDeleted());
        return itemDetailDto;
    }

    @Override
    public void updateStatus(List<Long> itemIds, String status) {
        this.qihoItemDAO.updateStatus(itemIds, status);
    }

    @Override
    public void deleteBatch(List<Long> itemIds) {
        this.qihoItemDAO.deleteBatch(itemIds);
        ItemDeleteEvent event = new ItemDeleteEvent();
        event.addAllItemId(itemIds);
        this.eventBus.post((Object)event);
    }

    @Override
    public List<ItemDto> findItemDtoByItemIds(Set<Long> itemIds) {
        List list = this.qihoItemDAO.findByIds((List)Lists.newArrayList(itemIds));
        ArrayList newList = Lists.newArrayList();
        for (QihoItemDetailEntity entity : list) {
            if (entity.getDeleted().booleanValue()) continue;
            newList.add(entity);
        }
        return this.convertToItemDto(newList);
    }

    @Override
    public List<ItemDto> findRecommendIndex() {
        List recommendList = this.qihoItemDAO.findRecommendIndex();
        return this.convertToItemDto(recommendList);
    }

    @Override
    public ItemSimpleDto queryItemSimpleDto(Long itemId) {
        QihoItemEntity entity = this.qihoItemDAO.findSimpleById(itemId);
        return (ItemSimpleDto)BeanUtils.copy((Object)entity, ItemSimpleDto.class);
    }
}

