/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.biz.service.SkinService;
import com.qiho.center.common.dao.QihoSkinDAO;
import com.qiho.center.common.entity.QihoSkinEntity;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkinServiceImpl
implements SkinService {
    @Autowired
    private QihoSkinDAO skinDAO;

    @Override
    public PagenationDto<SkinDto> queryAllSkin(QuerySkinParams params) {
        List skinDtoList = Lists.transform((List)this.skinDAO.queryAllSkin(params), this::convertDto);
        Integer count = this.skinDAO.countAllSkin(params);
        PagenationDto pagenationDto = new PagenationDto();
        pagenationDto.setList(skinDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public SkinDto querySkinById(Long id) {
        return this.convertDto(this.skinDAO.querySkinById(id));
    }

    @Override
    @Transactional(value="QIHO")
    public Long createSkin(SkinDto entity) {
        return this.skinDAO.createSkin(this.convertEntity(entity));
    }

    @Override
    @Transactional(value="QIHO")
    public int updateSkin(SkinDto entity) {
        return this.skinDAO.updateSkin(this.convertEntity(entity));
    }

    @Override
    @Transactional(value="QIHO")
    public int deleteSkin(Long id) {
        return this.skinDAO.deleteSkin(id);
    }

    private SkinDto convertDto(QihoSkinEntity entity) {
        if (entity == null) {
            return null;
        }
        SkinDto skinDto = new SkinDto();
        BeanUtils.copyProperties((Object)entity, (Object)skinDto);
        skinDto.setGmtModified(Long.valueOf(entity.getGmtModified().getTime()));
        return skinDto;
    }

    private QihoSkinEntity convertEntity(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        QihoSkinEntity entity = new QihoSkinEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        return entity;
    }
}

