/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.biz.bo.BlackListBo;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.biz.event.LogisticsInfoUpdateEvent;
import com.qiho.center.biz.event.OrderCreateEvent;
import com.qiho.center.biz.event.UpdateToCodEvent;
import com.qiho.center.biz.service.order.ChannelInfoService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.constant.DomainConstantUtil;
import com.qiho.center.common.dao.QihoAnticheateDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.QihoShortUrlDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoShortUrlEntity;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.model.tongdun.FraudApiResponse;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.MaxentUtil;
import com.qiho.center.common.util.ShortUrlUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import com.qiho.center.common.util.TongdunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class OrderSnapshotServiceImpl
implements OrderSnapshotService {
    private static final Logger LOG = LoggerFactory.getLogger(OrderSnapshotServiceImpl.class);
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoShortUrlDAO qihoShortUrlDAO;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    @Autowired
    private SmsService smsService;
    @Autowired
    private BlackListBo blackListBo;
    @Resource
    private ShotOrderEngine shotOrderEngine;
    @Autowired
    private QihoAnticheateDAO qihoAnticheateDAO;
    @Autowired
    private ChannelInfoService channelInfoService;

    @Override
    public PagenationDto<OrderSnapshotDto> findOrderPage(OrderPageParams params) {
        PagenationDto page = new PagenationDto();
        List list = this.qihoOrderSnapshotDAO.findOrderPage(params);
        page.setTotal(this.qihoOrderSnapshotDAO.findOrderPageCount(params));
        DtoTransform transform = new DtoTransform();
        List dtoList = Lists.transform((List)list, (Function)transform);
        page.setList(dtoList);
        return page;
    }

    @Override
    public List<OrderSnapshotDto> findOrderPageForExport(OrderPageParams params) {
        ArrayList list = Lists.newArrayList();
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                list.add(order);
            }
        } else {
            list.addAll(this.qihoOrderSnapshotDAO.exportOrderPage(params));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList orderIds = Lists.newArrayList();
        for (QihoOrderSnapshotEntity order : list) {
            orderIds.add(order.getOrderId());
        }
        List anticheatList = this.qihoAnticheateDAO.findByOrderIds((List)orderIds);
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)anticheatList)) {
            for (QihoAnticheateEntity anticheat : anticheatList) {
                String rules = (String)map.get(anticheat.getOrderId());
                if (StringUtils.isNotBlank((CharSequence)rules)) {
                    map.put(anticheat.getOrderId(), rules + "," + anticheat.getRule());
                    continue;
                }
                map.put(anticheat.getOrderId(), anticheat.getRule());
            }
        }
        DtoTransform transform = new DtoTransform();
        transform.setAnticheatMap(map);
        return Lists.transform((List)list, (Function)transform);
    }

    @Override
    public Integer findAllPageCount(OrderPageParams params) {
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                return 1;
            }
            return 0;
        }
        return this.qihoOrderSnapshotDAO.findOrderPageCount(params);
    }

    @Override
    public Integer exportOrderPageCount(OrderPageParams params) {
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                return 1;
            }
            return 0;
        }
        return this.qihoOrderSnapshotDAO.exportOrderPageCount(params);
    }

    @Override
    public Integer updateOrderStatus(String orderId, String remark, OrderStatusEnum orderStatus, OrderApprovalStatusEnum orderApprovalStatusEnum) {
        return this.qihoOrderSnapshotDAO.updateOrderStatus(orderId, remark, orderStatus, orderApprovalStatusEnum, null);
    }

    @Override
    public OrderSnapshotDto findByOrderId(String orderId) {
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (entity == null) {
            return null;
        }
        OrderSnapshotDto dto = (OrderSnapshotDto)BeanUtils.copy((Object)entity, OrderSnapshotDto.class);
        dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)entity.getOrderStatus()));
        dto.setDeliveryEnum(DeliveryEnum.getByCode((String)entity.getDelivery()));
        dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)entity.getFundStatus()));
        return dto;
    }

    @Subscribe
    public void createOrderListener(OrderCreateEvent orderCreateEvent) {
        OrderSnapshotDto orderSnapshotDto = orderCreateEvent.getOrderSnapshot();
        String orderId = orderSnapshotDto.getOrderId();
        String shortUrl = this.saveShortUrl(orderId);
        if (StringUtils.equals((CharSequence)orderSnapshotDto.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
            this.shotOrderEngine.process(orderSnapshotDto);
            this.sendMessage(orderSnapshotDto.getMobile(), orderSnapshotDto.getItemShortName(), shortUrl);
        }
        this.updateDeviceId(orderId, orderCreateEvent.getTokenId());
    }

    @Subscribe
    public void updateToCodListener(UpdateToCodEvent event) {
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(event.getOrderId());
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)order, OrderSnapshotDto.class);
        this.shotOrderEngine.process(orderSnapshotDto);
        String shortUrl = ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId());
        this.sendMessage(order.getMobile(), order.getItemShortName(), shortUrl);
    }

    private String saveShortUrl(String orderId) {
        String qihoWebUrl = DomainConstantUtil.getQihoWebUrl();
        String domain = StringUtils.substring((String)qihoWebUrl, (int)(StringUtils.indexOf((CharSequence)qihoWebUrl, (CharSequence)"//") + 2));
        String longUrl = qihoWebUrl + "/order/detail?orderId=" + orderId;
        int section = Integer.parseInt(StringUtils.substring((String)orderId, (int)15, (int)19));
        String shortUrl = ShortUrlUtil.generateShortUrl((String)longUrl, (int)section);
        QihoShortUrlEntity qihoShortUrlEntity = new QihoShortUrlEntity();
        qihoShortUrlEntity.setShortUrl(shortUrl);
        qihoShortUrlEntity.setLongUrl(longUrl);
        this.qihoShortUrlDAO.insert(qihoShortUrlEntity);
        return domain + "/" + shortUrl;
    }

    private void updateDeviceId(String orderId, String tokenId) {
        FraudApiResponse fraudApiResponse = TongdunUtil.getRiskInfo((String)tokenId);
        String tongdunId = fraudApiResponse.getDeviceId();
        ChannelInfoDto channelInfo = new ChannelInfoDto();
        channelInfo.setOrderId(orderId);
        channelInfo.addDeviceId("tongdunId", tongdunId);
        String maxentId = MaxentUtil.getDeviceId((String)tokenId);
        channelInfo.addDeviceId("maxentId", maxentId);
        this.channelInfoService.updateByOrderId(channelInfo);
    }

    private void sendMessage(String mobile, String itemShortName, String orderDetailUrl) {
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            HashMap context = Maps.newHashMap();
            context.put("orderDetailUrl", orderDetailUrl);
            context.put("itemName", itemShortName);
            String text = SimpleTemplateUtil.render((String)template.getTemplateContext(), (Map)context);
            this.smsService.singleSend(text, mobile);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            AppLogUtil.error((Logger)LOG, (String)"\u53d1\u9001\u77ed\u4fe1\u7ebf\u7a0b\u4e2d\u65ad", (Object[])new Object[]{e});
            Thread.currentThread().interrupt();
        }
        template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_NOTIFY.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            this.smsService.singleSend(template.getTemplateContext(), mobile);
        }
    }

    @Subscribe
    public void logisticsInfoUpdateListener(LogisticsInfoUpdateEvent event) {
        String postId = event.getPostId();
        String mobile = event.getMobile();
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SEND.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            HashMap context = Maps.newHashMap();
            context.put("postId", postId);
            context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId()));
            String text = SimpleTemplateUtil.render((String)template.getTemplateContext(), (Map)context);
            this.smsService.singleSend(text, mobile);
        }
    }

    @Override
    public List<OrderSnapshotDto> findByMobile(String mobile, List<String> statusList) {
        List list = this.qihoOrderSnapshotDAO.findByMobile(mobile, statusList);
        ArrayList orderList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return orderList;
        }
        for (QihoOrderSnapshotEntity input : list) {
            OrderSnapshotDto dto = new OrderSnapshotDto();
            BeanUtils.copy((Object)input, (Object)dto);
            dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)input.getFundStatus()));
            dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)input.getOrderStatus()));
            dto.setDeliveryEnum(DeliveryEnum.getByCode((String)input.getDelivery()));
            orderList.add(dto);
        }
        return orderList;
    }

    private class DtoTransform
    implements Function<QihoOrderSnapshotEntity, OrderSnapshotDto> {
        private Map<String, String> anticheatMap;

        private DtoTransform() {
        }

        public void setAnticheatMap(Map<String, String> anticheatMap) {
            this.anticheatMap = anticheatMap;
        }

        public OrderSnapshotDto apply(QihoOrderSnapshotEntity input) {
            if (input == null) {
                return null;
            }
            OrderSnapshotDto dto = new OrderSnapshotDto();
            BeanUtils.copy((Object)input, (Object)dto);
            dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)input.getFundStatus()));
            dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)input.getOrderStatus()));
            dto.setDeliveryEnum(DeliveryEnum.getByCode((String)input.getDelivery()));
            if (this.anticheatMap != null) {
                dto.setAnticheatRules(this.anticheatMap.get(input.getOrderId()));
            }
            return dto;
        }
    }
}

