/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.daoh.qiho.QihoItemSkuMapper;
import com.qiho.center.common.daoh.qiho.QihoOrderItemInfoMapper;
import com.qiho.center.common.entityd.qiho.QihoItemSku;
import com.qiho.center.common.entityd.qiho.QihoOrderItemInfo;
import com.qiho.center.common.util.AppLogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderStockServiceImpl
implements OrderStockService {
    private static final Logger logger = LoggerFactory.getLogger(OrderStockServiceImpl.class);
    @Autowired
    private QihoOrderItemInfoMapper qihoOrderItemInfoMapper;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    QihoItemSkuMapper qihoItemSkuMapper;
    @Autowired
    private RemoteStockService remoteStockService;

    @Override
    public DubboResult<Boolean> returnSkuStockByOrderId(String orderId) {
        List list = this.qihoOrderItemInfoMapper.selectQihoOrderItemInfosByOrderId(orderId);
        ArrayList increateList = Lists.newArrayList();
        for (QihoOrderItemInfo qihoOrderItemInfo : list) {
            UpdateStockReqDto reqDto = new UpdateStockReqDto();
            reqDto.setStockId(qihoOrderItemInfo.getStockId().longValue());
            reqDto.setStock((long)qihoOrderItemInfo.getQuantity().intValue());
            increateList.add(reqDto);
        }
        DubboResult result = this.remoteStockBackendService.increaseItemStockBatch((List)increateList);
        if (!result.isSuccess()) {
            AppLogUtil.error((Logger)logger, (String)"\u8ba2\u5355{}:\u5e93\u5b58\u8fd4\u8fd8\u5931\u8d25!", (Object[])new Object[]{orderId});
            throw new QihoException("\u5e93\u5b58\u8fd4\u8fd8\u5931\u8d25!");
        }
        AppLogUtil.info((Logger)logger, (String)"\u8ba2\u5355{}\uff1a\u8fd4\u8fd8\u5e93\u5b58\u6210\u529f!", (Object[])new Object[]{orderId});
        return result;
    }

    @Override
    public void handlerErpStocks(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> descreaseStock, List<ErpStock> stocks) {
        List<String> paramSkuNo = this.toConvert(stocks);
        List qihoItemSkus = this.qihoItemSkuMapper.selectALLItemSku(paramSkuNo);
        if (!qihoItemSkus.isEmpty()) {
            Map erpQ = this.qihoItemSkuMapper.selectErpOrderQuantityBySkuNo(paramSkuNo);
            Map ordQ = this.qihoItemSkuMapper.selectOrderQuantityBySkuNo(paramSkuNo);
            List<Long> stockIds = this.toConvertStockIds(qihoItemSkus);
            DubboResult stockDs = this.remoteStockService.findBatchByIds(stockIds);
            Map<String, QihoItemSku> qihoItemSkuMap = this.toConvertSkuMap(qihoItemSkus);
            Map<Long, StockDto> stockMaps = this.toConvertMap((DubboResult<List<StockDto>>)stockDs);
            for (ErpStock stock : stocks) {
                QihoItemSku sku = qihoItemSkuMap.get(stock.getSpecNo());
                if (sku == null) continue;
                this.handlerErpStock(increaseStock, descreaseStock, erpQ, ordQ, stockMaps, stock, sku);
            }
        }
    }

    private void handlerErpStock(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> descreaseStock, Map<String, Map<String, BigDecimal>> erpQ, Map<String, Map<String, BigDecimal>> ordQ, Map<Long, StockDto> stockMaps, ErpStock stock, QihoItemSku sku) {
        long erpNum = 0L;
        long orderNum = 0L;
        if (erpQ.get(stock.getSpecNo()) != null) {
            erpNum = erpQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        if (ordQ.get(stock.getSpecNo()) != null) {
            orderNum = ordQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        long quantity = erpNum + orderNum;
        long erpStock = (long)(stock.getStockNum() - stock.getOrderNum() - stock.getSendingNum());
        long totoleSkuNum = erpStock - quantity;
        long creaseNum = 0L;
        long stockId = sku.getStockId();
        long remoteStock = stockMaps.get(stockId).getStock();
        if (totoleSkuNum >= 0L) {
            creaseNum = totoleSkuNum - remoteStock;
        } else {
            creaseNum -= remoteStock;
            logger.warn("\u5e93\u5b58{}\u51fa\u73b0\u8d85\u5356,\u8bf7\u68c0\u67e5\u5e93\u5b58\uff0c\u5e93\u5b58\u5df2\u7f6e\u4e3a0", (Object)stockId);
        }
        if (creaseNum == 0L) {
            return;
        }
        UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
        updateStockReqDto.setStockId(stockId);
        updateStockReqDto.setStock(Math.abs(creaseNum));
        if (creaseNum > 0L) {
            increaseStock.add(updateStockReqDto);
        } else if (creaseNum < 0L) {
            descreaseStock.add(updateStockReqDto);
        }
    }

    private Map<String, QihoItemSku> toConvertSkuMap(List<QihoItemSku> qihoItemSkus) {
        HashMap<String, QihoItemSku> result = new HashMap<String, QihoItemSku>();
        for (QihoItemSku itemSkus : qihoItemSkus) {
            result.put(itemSkus.getSkuNo(), itemSkus);
        }
        return result;
    }

    private List<Long> toConvertStockIds(List<QihoItemSku> qihoItemSkus) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (QihoItemSku itemSkus : qihoItemSkus) {
            result.add(itemSkus.getStockId());
        }
        return result;
    }

    private Map<Long, StockDto> toConvertMap(DubboResult<List<StockDto>> stockDs) {
        HashMap<Long, StockDto> result = new HashMap<Long, StockDto>();
        List list = (List)stockDs.getResult();
        for (StockDto stockDto : list) {
            result.put(stockDto.getStockID(), stockDto);
        }
        return result;
    }

    private List<String> toConvert(List<ErpStock> stocks) {
        ArrayList<String> result = new ArrayList<String>();
        for (ErpStock stock : stocks) {
            result.add(String.valueOf(stock.getSpecNo()));
        }
        return result;
    }
}

