/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.service.order.OrderStrategyService;
import com.qiho.center.common.dao.QihoOrderStrategyDAO;
import com.qiho.center.common.entity.order.QihoOrderStrategyEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderStrategyServiceImpl
implements OrderStrategyService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private QihoOrderStrategyDAO qihoOrderStrategyDAO;

    @Override
    public OrderStrategyDto findStrategyById(Long id) {
        QihoOrderStrategyEntity entity = this.qihoOrderStrategyDAO.findStrategyById(id);
        if (null == entity) {
            return null;
        }
        return (OrderStrategyDto)BeanUtils.copy((Object)entity, OrderStrategyDto.class);
    }

    @Override
    public PagenationDto<OrderStrategyDto> findStrategyByQuery(OrderStrategyParams params, Integer pageNum, Integer pageSize) {
        ArrayList channelDtos = new ArrayList();
        PagenationDto resultBase = new PagenationDto();
        List entities = this.qihoOrderStrategyDAO.findStrategyByQuery(params, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return resultBase;
        }
        entities.stream().forEach(e -> channelDtos.add(BeanUtils.copy((Object)e, OrderStrategyDto.class)));
        resultBase.setList(channelDtos);
        Integer channelCount = this.qihoOrderStrategyDAO.countByQuery(params);
        resultBase.setTotal(channelCount);
        return resultBase;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateStrategy(OrderStrategyDto orderStrategyDto) {
        return this.qihoOrderStrategyDAO.updateByEntity(orderStrategyDto);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer deleteStrategyById(Long id) {
        return this.qihoOrderStrategyDAO.deleteById(id);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer insertStrategy(OrderStrategyDto orderStrategyDto) {
        Long result = this.qihoOrderStrategyDAO.insertStrategy(orderStrategyDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    @Override
    public Integer countStrategyByQuery(OrderStrategyParams params) {
        return this.qihoOrderStrategyDAO.countByQuery(params);
    }

    @Override
    public OrderStrategyDto findStrategyByStrategyType(StrategyType type) {
        QihoOrderStrategyEntity entity = this.qihoOrderStrategyDAO.findStrategyByStrategyType(Integer.valueOf(type.getCode()));
        if (null == entity) {
            return null;
        }
        return (OrderStrategyDto)BeanUtils.copy((Object)entity, OrderStrategyDto.class);
    }
}

