/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.params.OrderQueryParams;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderTaskService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.util.ShortUrlUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderTaskServiceImpl
implements OrderTaskService {
    private static Logger log = LoggerFactory.getLogger(OrderTaskServiceImpl.class);
    private static final int PAGE_SIZE = 100;
    private SimpleDateFormat format = new SimpleDateFormat("MM\u6708dd\u65e5HH\u65f6mm\u5206");
    @Autowired
    private SmsService smsService;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    @Autowired
    private FundOrderService fundOrderService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PayChannelDecider payChannelDecider;

    @Override
    public void remainOrderPay() {
        OrderQueryParams params = new OrderQueryParams();
        params.setOrderStatus(OrderStatusEnum.TO_PAY.getCode());
        params.setGmtCreateStart(DateUtils.addMinutes((Date)DateUtils.setSeconds((Date)new Date(), (int)0), (int)-20));
        params.setGmtCreateEnd(DateUtils.addMinutes((Date)DateUtils.setSeconds((Date)new Date(), (int)0), (int)-15));
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.PAY_REMIND.getCode());
        int pageNum = 1;
        while (true) {
            params.setOffset(Integer.valueOf((pageNum - 1) * 100));
            params.setMax(Integer.valueOf(100));
            List orderList = this.qihoOrderDAO.findOrderPageListByParams(params);
            if (CollectionUtils.isEmpty((Collection)orderList)) break;
            for (QihoOrderEntity entity : orderList) {
                try {
                    HashMap context = Maps.newHashMap();
                    context.put("payLimitTime", this.format.format(DateUtils.addMinutes((Date)entity.getGmtCreate(), (int)30)));
                    context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId((String)entity.getOrderId()));
                    String text = SimpleTemplateUtil.render((String)template.getTemplateContext(), (Map)context);
                    this.smsService.singleSend(text, entity.getMobile());
                }
                catch (Exception e) {
                    log.error("OrderTaskServiceImpl call remainOrderPay error, entity => {}", (Object)JSON.toJSONString((Object)entity), (Object)e);
                }
            }
            ++pageNum;
        }
    }

    @Override
    public void closeOverTimeOrder() {
        OrderQueryParams params = new OrderQueryParams();
        params.setOrderStatus(OrderStatusEnum.TO_PAY.getCode());
        params.setGmtCreateEnd(DateUtils.addHours((Date)new Date(), (int)-1));
        int pageNum = 1;
        while (true) {
            params.setOffset(Integer.valueOf((pageNum - 1) * 100));
            params.setMax(Integer.valueOf(100));
            List orderList = this.qihoOrderDAO.findOrderPageListByParams(params);
            if (CollectionUtils.isEmpty((Collection)orderList)) break;
            for (QihoOrderEntity entity : orderList) {
                try {
                    List<FundOrderDto> fundOrderList = this.fundOrderService.findByOrderIdAndBizType(entity.getOrderId(), FundBizTypeEnum.PAY.getCode());
                    if (CollectionUtils.isEmpty(fundOrderList)) {
                        this.orderService.closeOrder(entity.getOrderId(), "\u4ed8\u6b3e\u5931\u8d25", null);
                        continue;
                    }
                    FundOrderDto fundOrder = fundOrderList.get(0);
                    PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)fundOrder.getPayType()));
                    PayDto result = payChannelProcessor.queryPayResult(entity.getOrderId());
                    if (result.isSuccess()) {
                        AsyncAcceptParams param = new AsyncAcceptParams();
                        param.setAccount(result.getPayerId());
                        param.setOrderId(entity.getOrderId());
                        param.setOutSqeNo(result.getOutTradeNo());
                        param.setReceiptAmount(result.getPayAmt());
                        payChannelProcessor.processNotify(param);
                        continue;
                    }
                    this.orderService.closeOrder(entity.getOrderId(), FundStatusEnum.FAILED.getDesc(), fundOrder.getFundId());
                }
                catch (Exception e) {
                    log.error("OrderTaskServiceImpl call remainOrderPay error, entity => {}", (Object)JSON.toJSONString((Object)entity), (Object)e);
                }
            }
            ++pageNum;
        }
    }

    @Override
    public void syncFundOrderStatus() {
        int pageNum = 1;
        FundPageParam param = new FundPageParam();
        param.setBizType(FundBizTypeEnum.REFUND.getCode());
        param.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        param.setMax(Integer.valueOf(100));
        while (true) {
            param.setOffset(Integer.valueOf((pageNum - 1) * 100));
            PagenationDto<FundOrderDto> pageResult = this.fundOrderService.queryFundPage(param);
            List list = pageResult.getList();
            if (CollectionUtils.isEmpty((Collection)list)) break;
            for (FundOrderDto dto : list) {
                try {
                    this.doProcess(dto);
                }
                catch (Exception e) {
                    log.error("OrderTaskServiceImpl call syncFundOrderStatus error, entity => {}", (Object)JSON.toJSONString((Object)dto), (Object)e);
                }
            }
            ++pageNum;
        }
    }

    private void doProcess(FundOrderDto dto) {
        if (Objects.equal((Object)PayTypeEnum.getEnumByCode((String)dto.getPayType()), (Object)PayTypeEnum.COD)) {
            return;
        }
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)dto.getPayType()));
        RefundResult result = payChannelProcessor.refundQuery(dto.getOrderId(), dto.getFundId());
        if (null == result.getIsSuccess() || !result.getIsSuccess().booleanValue()) {
            return;
        }
        if (StringUtils.equals((String)result.getRefundStatus(), (String)"processing")) {
            return;
        }
        dto.setFundStatus(StringUtils.equals((String)result.getRefundStatus(), (String)"success") ? FundStatusEnum.SUCCESS.getCode() : FundStatusEnum.FAILED.getCode());
        dto.setOutSeqNo(StringUtils.isBlank((String)result.getOutTradeNo()) ? dto.getOutSeqNo() : result.getOutTradeNo());
        this.fundOrderService.update(dto);
    }
}

