/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.postsale;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.postsale.PostsaleService;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PostsaleServiceImpl
implements PostsaleService {
    private static final Logger LOG = LoggerFactory.getLogger(PostsaleServiceImpl.class);
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Autowired
    private FundOrderService fundOrderService;

    @Override
    @Transactional(value="QIHO")
    public void postsaleSuccess(String orderId) {
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (order == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)OrderStatusEnum.SUCCESS.getCode(), (CharSequence)order.getOrderStatus())) {
            LOG.warn("\u9000\u8d27\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u9519\u8bef\uff0corderId=" + orderId + " orderStatus=" + order.getOrderStatus());
            throw new QihoException("\u9000\u8d27\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        QihoOrderEntity updateOrder = new QihoOrderEntity();
        updateOrder.setOrderId(orderId);
        updateOrder.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        updateOrder.setRemark("\u9000\u8d27\u6210\u529f");
        this.qihoOrderDAO.updateByOrderId(updateOrder);
        QihoOrderSnapshotEntity orderSnapshot = (QihoOrderSnapshotEntity)BeanUtils.copy((Object)updateOrder, QihoOrderSnapshotEntity.class);
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
        if (!StringUtils.equals((CharSequence)order.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) && StringUtils.equals((CharSequence)order.getFundStatus(), (CharSequence)FundStatusEnum.SUCCESS.getCode())) {
            this.fundOrderService.refund(orderId, order.getPayType(), order.getOrderAmt());
        }
    }
}

