package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.runnable.AuditOrderRunnable;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.enums.CacheConstantseEnum;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * Created by liuyao on 2017/6/5.
 */
@Service
public class OrderBo implements ApplicationContextAware {

    private ApplicationContext context;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;

    /**
     * 批量审核订单
     * @param progressKey
     * @param paramList
     * @return
     */
    public Integer batchAuditOrder(String progressKey, List<OrderAuditParams> paramList){
        AuditOrderRunnable runnable = context.getBean(AuditOrderRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        executorService.submit(runnable);
        return enableCount;
    }

    public void updateOrderStatus(String orderId, OrderStatusEnum orderStatus){
        orderService.updateOrderStatus(orderId,orderStatus);
        orderSnapshotService.updateOrderStatus(orderId, orderStatus);
    }

    /**
     * 将主订单变成失败
     * @param orderId
     * @param remark
     */
    @Transactional(DsConstants.DATABASE_QIHO)
    public void rejectOrder(String orderId,String remark){
        orderService.rejectOrder(orderId,remark);
        orderSnapshotService.updateOrderStatus(orderId, OrderStatusEnum.CLOSED);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}
