/**
 * Project Name:qiho-center-biz File Name:LogisticsUpdateEvent.java Package Name:com.qiho.center.biz.event
 * Date:2017年6月13日下午2:11:47 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.event;

import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.common.annotations.AsyncEvent;

/**
 * ClassName:LogisticsUpdateEvent <br/>
 * 物流状态更新事件. <br/>
 * Date: 2017年6月13日 下午2:11:47 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@AsyncEvent
public class LogisticsUpdateEvent {

    /** 订单ID */
    private String                   orderId;

    /** erpID */
    private String                   erpId;

    /** 物流状态 */
    private YTOLogisticsStatusEnum   logisticsStatus;

    /** 物流订单状态，UNDER_WAY-在途/SUCCESS-签收成功/FAILED-签收失败 */
    private LogisticsOrderStatusEnum orderStatus;

    /**
     * erpId.
     *
     * @return the erpId
     */
    public String getErpId() {
        return erpId;
    }

    /**
     * erpId.
     *
     * @param erpId the erpId to set
     */
    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public LogisticsOrderStatusEnum getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(LogisticsOrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * logisticsStatus.
     *
     * @return the logisticsStatus
     */
    public YTOLogisticsStatusEnum getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * logisticsStatus.
     *
     * @param logisticsStatus the logisticsStatus to set
     */
    public void setLogisticsStatus(YTOLogisticsStatusEnum logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }
}
