/**
 * Project Name:qiho-center-biz File Name:OrderCreateEvent.java Package Name:com.qiho.center.biz.event
 * Date:2017年6月3日上午11:16:18 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.event;

import java.io.Serializable;

import com.qiho.center.common.annotations.AsyncEvent;

/**
 * ClassName:OrderCreateEvent <br/>
 * 新增订单事件. <br/>
 * Date: 2017年6月3日 上午11:16:18 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@AsyncEvent
public class OrderCreateEvent implements Serializable {

    /**
     */
    private static final long serialVersionUID = 5344848277270695318L;

    /** 订单编号 */
    private String            orderId;
    
    /**
     * Creates a new instance of OrderCreateEvent.
     *
     * @param orderId
     */
    
    public OrderCreateEvent(String orderId) {
        this.orderId = orderId;
    }

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }
}
