package com.qiho.center.biz.job;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import com.qiho.center.biz.bo.LogisticsOrderBo;

/**
 * 定时任务，去ERP系统查询物流发货信息.
 * date: 2017年6月8日 下午4:49:50 <br/>
 *
 * @author chencheng
 * @version
 */
@Component
public class ErpLogisticsSyncQueryTaskJob extends AbstractSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErpLogisticsSyncQueryTaskJob.class);
    private static final String SECOND = "yyyy-MM-dd HH:mm:ss";
    
    @Autowired
    private LogisticsOrderBo logisticsOrderBo;
    
    @Override
    public void process(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.error("ErpLogisticsSyncQueryJob   启动成功");
    	
        logisticsOrderBo.erpLogisticsSyncQuery();
        SimpleDateFormat format = new SimpleDateFormat(SECOND);
        LOGGER.info("############## ERP物流信息同步成功(ErpLogisticsSyncQueryTaskJob 执行成功)  执行时间【{}】##############", format.format(new Date()));
    }

}
