package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Objects;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BandParams;
import com.qiho.center.api.remoteservice.RemoteBandService;
import com.qiho.center.biz.service.BandService;
import com.qiho.center.common.support.ValidatorTool;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 2017/5/24.
 */
@Service
public class RemoteBandServiceImpl implements RemoteBandService {

    private Logger logger = LoggerFactory.getLogger(RemoteBandServiceImpl.class);

    @Autowired
    private BandService bandService;

    @Override
    public DubboResult<List<BandDto>> findAllBand() {
        return DubboResult.successResult(bandService.findAllBand());
    }

    @Override
    public DubboResult<Integer> saveBand(BandParams params) {
        try{
            ValidatorTool.valid(params);
            if(Objects.equal(null,params.getId())&& StringUtils.isBlank(params.getUrl())){
                throw new QihoException("Band创建的时候必须设置链接");
            }
            bandService.saveBand(params);
            return DubboResult.successResult(1);
        }catch(Exception e){
            logger.info("Band保存失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> changeBandShowEnable(Long id) {
        return DubboResult.successResult(bandService.changeBandShowEnable(id));
    }

    @Override
    public DubboResult<Integer> sortBand(List<Long> bandIds) {
        return DubboResult.successResult(bandService.sortBand(bandIds));
    }

    @Override
    public DubboResult<Integer> deleteBand(Long id) {
        return DubboResult.successResult(bandService.deleteBand(id));
    }
}
