package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.center.biz.service.ExpressBlackListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * Created by liuyao on 2017/5/22.
 */
@Service
public class RemoteExpressBlackListServiceImpl implements RemoteExpressBlackListService {

    @Autowired
    private ExpressBlackListService expressBlackListService;

    @Override
    public DubboResult<PagenationDto<ExpressBlackListDto>> findExpressBlackPage(ExpressBlackListPageParams params) {
        return DubboResult.successResult(expressBlackListService.findExpressBlackPage(params));
    }

    @Override
    public DubboResult<Long> findOneBlack(ExpressCompanyEnum expressCompany, String addressCode) {
        return DubboResult.successResult(expressBlackListService.findOneBlack(expressCompany,addressCode));
    }

    @Override
    public DubboResult<Boolean> deleteBlackList(Long id) {
        return DubboResult.successResult(expressBlackListService.deleteBlackList(id));
    }

    @Override
    public DubboResult<Integer> batchAddExpressBlackList(ExpressCompanyEnum expressCompany,Set<String> addressCodes){
        return DubboResult.successResult(expressBlackListService.batchAddExpressBlackList(expressCompany,addressCodes));
    }

}
