/**
 * Project Name:qiho-center-biz
 * File Name:RemoteTemplateServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl
 * Date:2017年6月21日上午9:36:00
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.remoteservice.RemoteTemplateService;
import com.qiho.center.biz.service.TemplateService;


/**
 * ClassName:RemoteTemplateServiceImpl <br/>
 * 模板服务. <br/>
 * Date:     2017年6月21日 上午9:36:00 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteTemplateServiceImpl implements RemoteTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTemplateServiceImpl.class);
    
    @Autowired
    private TemplateService templateService;
    
    @Override
    public DubboResult<Void> enableSwitch(Long id, Boolean enable) {
        try {
            templateService.enableSwitch(id, enable);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.switchTemplate failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

