/**
 * Project Name:qiho-center-biz
 * File Name:RemoteUrlServiceImpl.java
 * Package Name:com.qiho.center.biz.service.impl
 * Date:2017年6月20日下午5:35:32
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.remoteservice.RemoteUrlService;
import com.qiho.center.biz.service.UrlService;

/**
 * ClassName:RemoteUrlServiceImpl <br/>
 * 链接服务接口实现类. <br/>
 * Date:     2017年6月20日 下午5:35:32 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteUrlServiceImpl implements RemoteUrlService{
    private static final Logger LOG = LoggerFactory.getLogger(RemoteUrlServiceImpl.class);

    @Autowired
    private UrlService urlService;
    
    /**
     * @see com.qiho.center.api.remoteservice.RemoteUrlService#getLongUrl(java.lang.String)
     */
    @Override
    public DubboResult<String> getLongUrl(String shortUrl) {
        try {
            String longUrl = urlService.getLongUrl(shortUrl);
            return DubboResult.successResult(longUrl);
        } catch (Exception e) {
            LOG.error("invoke RemoteUrlService.getLongUrl failed, shortUrl={}", shortUrl, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

