/**
 * Project Name:qiho-center-biz
 * File Name:RemoteAnticheateServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.order
 * Date:2017年6月6日下午1:41:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.order;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.AnticheateDto;
import com.qiho.center.api.remoteservice.order.RemoteAnticheateService;
import com.qiho.center.biz.service.order.AnticheateService;


/**
 * ClassName:RemoteAnticheateServiceImpl <br/>
 * 防作弊Dubbo服务实现类. <br/>
 * Date:     2017年6月6日 下午1:41:27 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteAnticheateServiceImpl implements RemoteAnticheateService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAnticheateServiceImpl.class);
    @Autowired
    private AnticheateService anticheateService;
    
    @Override
    public DubboResult<AnticheateDto> findByOrderId(String orderId) {
        try{
            AnticheateDto anticheateDto = anticheateService.findByOrderId(orderId);
            return DubboResult.successResult(anticheateDto);
        }catch(Exception e){
            LOG.error("invoke RemoteAnticheateService.findByOrderId failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

