/**
 * Project Name:qiho-center-biz
 * File Name:RemoteErpOrderServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.order
 * Date:2017年6月6日上午11:57:13
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.order;

import java.util.List;
import java.util.concurrent.ExecutorService;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.runnable.DealWithErpOrderDeliverRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;

import javax.annotation.Resource;


/**
 * ClassName:RemoteErpOrderServiceImpl <br/>
 * ERP订单Dubbo服务实现类. <br/>
 * Date:     2017年6月6日 上午11:57:13 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteErpOrderServiceImpl implements RemoteErpOrderService,ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteErpOrderServiceImpl.class);
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Resource
    private ExecutorService executorService;

    private ApplicationContext applicationContext;
    
    @Override
    public DubboResult<List<ErpOrderDto>> findByOrderId(String orderId) {
        try{
            List<ErpOrderDto> list = erpOrderService.findByOrderId(orderId);
            return DubboResult.successResult(list);
        }catch(Exception e){
            LOG.error("invoke RemoteErpOrderService.findByOrderId failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PagenationDto<ErpOrderDto>> findErpOrderPage(ErpOrderPageParams params) {
        return DubboResult.successResult(erpOrderService.findErpOrderPage(params));
    }

    @Override
    public DubboResult<Boolean> cancelDeliver(String erpId) {
        try{
            erpOrderBo.cancelDeliver(erpId);
            return DubboResult.successResult(true);
        }catch(Exception e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> resolveDeliver(ResolveDeliverParams params) {
        try{
            erpOrderBo.resolveDeliver(params);
            return DubboResult.successResult(true);
        }catch(Exception e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> batchResolveErpDeliver(String progressKey, List<BatchResolveErpDeliverParams> paramList) {
        try{
            DealWithErpOrderDeliverRunnable runnable = applicationContext.getBean(DealWithErpOrderDeliverRunnable.class);
            runnable.setProgressKey(progressKey);
            runnable.setParamsList(paramList);
            int size = runnable.init();
            executorService.submit(runnable);
            return DubboResult.successResult(size);
        }catch(Exception e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

