/**
 * Project Name:qiho-center-biz
 * File Name:RemoteFundOrderServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.order
 * Date:2017年6月6日下午1:00:56
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.order;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.biz.service.order.FundOrderService;


/**
 * ClassName:RemoteFundOrderServiceImpl <br/>
 * Date:     2017年6月6日 下午1:00:56 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteFundOrderServiceImpl implements RemoteFundOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFundOrderServiceImpl.class);
    @Autowired
    private FundOrderService fundOrderService;
    
    @Override
    public DubboResult<List<FundOrderDto>> findByOrderId(String orderId) {
        try{
            List<FundOrderDto> list = fundOrderService.findByOrderId(orderId);
            return DubboResult.successResult(list);
        }catch(Exception e){
            LOG.error("invoke RemoteFundOrderService.findByOrderId failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#queryFundPage(com.qiho.center.api.params.FundPageParam)
     */
    @Override
    public DubboResult<PagenationDto<FundOrderDto>> queryFundPage(FundPageParam param) {
        try{
            PagenationDto<FundOrderDto> page = fundOrderService.queryFundPage(param);
            return DubboResult.successResult(page);
        }catch(Exception e){
            LOG.error("invoke RemoteFundOrderService.queryFundPage failed,param={}",param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

