package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.RedisCacheClient;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.service.order.OrderService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by liuyao on 2017/6/5.
 */
@Component
@Scope("prototype")
public class AuditOrderRunnable implements Runnable  {

    private Logger logger = LoggerFactory.getLogger(AuditOrderRunnable.class);
    @Autowired
    private OrderService orderService;
    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    private List<OrderAuditParams> params = Lists.newArrayList();

    private BoundHashOperations<String,String,Object> ops;

    @Override
    public void run() {
        long failCount = 0L;
        try{
            for(OrderAuditParams param:params){
                try{
                    Boolean result = orderService.auditOrder(param);
                    if(!result){
                        failCount++;
                    }
                }catch(Exception e){
                    failCount++;
                    logger.error("订单审核失败",e);
                }finally {
                    ops.increment("successCount",1L);
                }
            }
        }finally {
            ops.increment("failCount",failCount);
            ops.increment("taskCount",-1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParams(List<OrderAuditParams> params) {
        this.params.addAll(params);
    }

    /**
     *
     * @return
     */
    public Integer enableFilter(){
        List<OrderAuditParams> newList = Lists.newArrayList();
        for(OrderAuditParams param:this.params){
            if(StringUtils.isBlank(param.getOrderId()) || Objects.equal(null,param.getAuditResult())){
                continue;
            }
            newList.add(param);
        }
        params.clear();
        params.addAll(newList);
        return newList.size();
    }
}
