package com.qiho.center.biz.service;

import java.util.Set;

import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListPageParams;

/**
 * Created by liuyao on 2017/5/22.
 * 快递黑名单服务
 */
public interface ExpressBlackListService {

    /**
     * 分页查询快递黑名单
     * @param params
     * @return
     */
    PagenationDto<ExpressBlackListDto> findExpressBlackPage(ExpressBlackListPageParams params);

    /**
     * 验证单个黑名单的存在
     * @param expressCompany
     * @param addressCode
     * @return 存在返回id,不存在返回为空
     */
    Long findOneBlack(ExpressCompanyEnum expressCompany, String addressCode);

    /**
     * 删除单个
     * @param id
     * @return
     */
    Boolean deleteBlackList(Long id);

    /**
     * 批量添加收货黑名单地址
     * @param expressCompany
     * @param addressCodes
     * @return
     */
    Integer batchAddExpressBlackList(ExpressCompanyEnum expressCompany, Set<String> addressCodes);
}
