/**
 * Project Name:qiho-center-biz
 * File Name:ItemRecommendService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月22日上午10:18:04
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import java.util.List;
import java.util.Set;

import com.qiho.center.common.entity.item.QihoItemRecommendEntity;

/**
 * ClassName: ItemRecommendService <br/>
 * date: 2017年5月22日 上午10:18:04 <br/>
 *
 * @author zhanglihui
 * @version 
 * 
 */
public interface ItemRecommendService {

    /**
     * 商品批量推荐
     * @author zhanglihui
     * @param itemIds
     */
    void recommendBatch(List<Long> itemIds);

    /**
     * 获取所有商品分类
     * @return
     */
    List<QihoItemRecommendEntity> findAllItemRecommend();

    /**
     * 去除商品的推荐
     * @param itemIds
     * @return
     */
    int deleteItemRecommend(Set<Long> itemIds);


    int sortItemRecommend(List<Long> itemIds);
}

