package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.biz.service.ExpressBlackListService;
import com.qiho.center.common.dao.QihoBlacklistDAO;
import com.qiho.center.common.entity.QihoBlacklistEntity;
import com.qiho.center.common.enums.BlackListEnum;
import com.qiho.center.common.params.BlackListPageParams;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/22.
 */
@Service
public class ExpressBlackListServiceImpl implements ExpressBlackListService {

    /**
     * 维护快递公司到名单之间的关系(可逆MAP)
     */
    private final BiMap<ExpressCompanyEnum, BlackListEnum> blackListTypeMap = HashBiMap.create();
    {
        blackListTypeMap.put(ExpressCompanyEnum.YTO,BlackListEnum.EXPRESS_YUAN_TONG);
    }

    @Autowired
    private QihoBlacklistDAO qihoBlacklistDAO;

    @Override
    public PagenationDto<ExpressBlackListDto> findExpressBlackPage(ExpressBlackListPageParams params) {
        PagenationDto<ExpressBlackListDto> page = new PagenationDto<>();
        BlackListPageParams daoParams = new BlackListPageParams();
        BeanUtils.copy(params,daoParams);

        BlackListEnum blackListEnum = blackListTypeMap.get(params.getExpressCompany());
        daoParams.setBkType(blackListEnum.getBkType());
        if(StringUtils.isNotBlank(params.getAddressCode())){
            daoParams.setBkValue(params.getAddressCode());
        }

        List<QihoBlacklistEntity> list = qihoBlacklistDAO.findQihoBlacklistPage(daoParams);
        Integer total = qihoBlacklistDAO.findQihoBlacklistTotal(daoParams);

        List<ExpressBlackListDto> returnList = Lists.transform(list,(entity)->{
            ExpressBlackListDto dto = new ExpressBlackListDto();
            dto.setExpressCompany(blackListTypeMap.inverse().get(BlackListEnum.getEnumByType(entity.getBkType())));
            dto.setAddressCode(entity.getBkValue());
            dto.setId(entity.getId());
            return dto;
        });

        page.setTotal(total);
        page.setList(returnList);

        return page;
    }

    @Override
    public Long findOneBlack(ExpressCompanyEnum expressCompany, String addressCode) {
        QihoBlacklistEntity entity = qihoBlacklistDAO.findOneBlacklist(blackListTypeMap.get(expressCompany),addressCode);
        if(Objects.equal(entity,null)){
            return null;
        }else{
            return entity.getId();
        }
    }

    @Override
    public Boolean deleteBlackList(Long id) {
        int ret = qihoBlacklistDAO.deleteBlackList(id);
        return ret==1;
    }

    @Override
    public Integer batchAddExpressBlackList(ExpressCompanyEnum expressCompany, Set<String> addressCodes) {

        BlackListEnum blackListEnum = blackListTypeMap.get(expressCompany);
        List<String> list = qihoBlacklistDAO.findExistByTypeAndIdSet(blackListEnum,addressCodes);
        Set<String> existSet = Sets.newHashSet(list);
        return qihoBlacklistDAO.batchAddBlackList(blackListTypeMap.get(expressCompany),Sets.difference(addressCodes,existSet));
    }


}
