/**
 * Project Name:qiho-center-biz
 * File Name:AnticheateServiceImpl.java
 * Package Name:com.qiho.center.biz.service.impl.order
 * Date:2017年6月6日下午1:43:44
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.impl.order;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.AnticheateDto;
import com.qiho.center.biz.service.order.AnticheateService;
import com.qiho.center.common.dao.QihoAnticheateDAO;


/**
 * ClassName:AnticheateServiceImpl <br/>
 * Date:     2017年6月6日 下午1:43:44 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class AnticheateServiceImpl implements AnticheateService {
    @Autowired
    private QihoAnticheateDAO qihoAnticheateDAO;
    
    @Override
    public AnticheateDto findByOrderId(String orderId) {
        List<String>  rules = qihoAnticheateDAO.findByOrderId(orderId);
        AnticheateDto anticheateDto = new AnticheateDto();
        anticheateDto.setOrderId(orderId);
        anticheateDto.setRules(rules);
        return anticheateDto;
    }

}

