/**
 * Project Name:qiho-center-biz File Name:PostsaleServiceImpl.java Package
 * Name:com.qiho.center.biz.service.impl.postsale Date:2017年6月12日下午7:05:33 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package com.qiho.center.biz.service.impl.postsale;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.postsale.PostsaleService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;

/**
 * ClassName:PostsaleServiceImpl <br/>
 * 售后服务实现类. <br/>
 * Date: 2017年6月12日 下午7:05:33 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class PostsaleServiceImpl implements PostsaleService {

    private static final Logger LOG = LoggerFactory.getLogger(PostsaleServiceImpl.class);

    @Autowired
    private QihoOrderDAO        qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public void postsaleSuccess(String orderId) {
        QihoOrderEntity order = qihoOrderDAO.findByOrderId(orderId);
        if (order == null) {
            return;
        }
        if (!StringUtils.equals(OrderStatusEnum.SUCCESS.getCode(), order.getOrderStatus())) {
            LOG.warn("退货失败，订单状态错误，orderId=" + orderId + " orderStatus=" + order.getOrderStatus());
            throw new QihoException("退货失败，订单状态错误");
        }
        QihoOrderEntity updateOrder = new QihoOrderEntity();
        updateOrder.setOrderId(orderId);
        updateOrder.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        updateOrder.setRemark("退货成功");
        qihoOrderDAO.updateByOrderId(updateOrder);
        QihoOrderSnapshotEntity orderSnapshot = BeanUtils.copy(updateOrder, QihoOrderSnapshotEntity.class);
        qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
    }

}
